/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpSelf;

public class OtpErlangPort
extends OtpErlangObject {
    private static final long serialVersionUID = 4037115468007644704L;
    private final int tag;
    private final String node;
    private final int id;
    private final int creation;

    private OtpErlangPort(OtpSelf otpSelf) {
        OtpErlangPort otpErlangPort = otpSelf.createPort();
        this.tag = otpErlangPort.tag;
        this.id = otpErlangPort.id;
        this.creation = otpErlangPort.creation;
        this.node = otpErlangPort.node;
    }

    public OtpErlangPort(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        OtpErlangPort otpErlangPort = otpInputStream.read_port();
        this.tag = otpErlangPort.tag;
        this.node = otpErlangPort.node();
        this.id = otpErlangPort.id();
        this.creation = otpErlangPort.creation();
    }

    public OtpErlangPort(String string, int n, int n2) {
        this(102, string, n, n2);
    }

    public OtpErlangPort(int n, String string, int n2, int n3) {
        this.tag = n;
        this.node = string;
        if (n == 102) {
            this.id = n2 & 0xFFFFFFF;
            this.creation = n3 & 3;
        } else {
            this.id = n2;
            this.creation = n3;
        }
    }

    protected int tag() {
        return this.tag;
    }

    public int id() {
        return this.id;
    }

    public int creation() {
        return this.creation;
    }

    public String node() {
        return this.node;
    }

    @Override
    public String toString() {
        return "#Port<" + this.node + "." + this.id + ">";
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_port(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangPort)) {
            return false;
        }
        OtpErlangPort otpErlangPort = (OtpErlangPort)object;
        return this.creation == otpErlangPort.creation && this.id == otpErlangPort.id && this.node.compareTo(otpErlangPort.node) == 0;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(6);
        hash.combine(this.creation);
        hash.combine(this.id, this.node.hashCode());
        return hash.valueOf();
    }
}

