/*
 * Decompiled with CFR 0.152.
 */
package org.grails.config;

import grails.config.Config;
import grails.util.GrailsStringUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.grails.config.NavigableMapConfig;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.springframework.util.ClassUtils;

public class CompositeConfig
implements Config {
    protected Deque<Config> configs = new ArrayDeque<Config>();

    public void addFirst(Config config) {
        this.configs.addFirst(config);
    }

    public void addLast(Config config) {
        this.configs.addLast(config);
    }

    @Override
    @Deprecated
    public Map<String, Object> flatten() {
        LinkedHashMap<String, Object> flattened = new LinkedHashMap<String, Object>();
        for (Config c : this.configs) {
            flattened.putAll(c.flatten());
        }
        return flattened;
    }

    @Override
    public Properties toProperties() {
        Properties properties = new Properties();
        for (Config c : this.configs) {
            properties.putAll((Map<?, ?>)c.toProperties());
        }
        return properties;
    }

    @Override
    public Config merge(Map<String, Object> toMerge) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue, List<T> allowedValues) {
        T v = this.getProperty(key, targetType, defaultValue);
        if (!allowedValues.contains(v)) {
            throw new GrailsConfigurationException("Invalid configuration value [$value] for key [${key}]. Possible values $allowedValues");
        }
        return v;
    }

    public Object getAt(Object key) {
        for (Config c : this.configs) {
            Object v = c.getAt(key);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public void setAt(Object key, Object value) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public Object navigate(String ... path) {
        for (Config c : this.configs) {
            Object v = c.navigate(path);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public int size() {
        int size = 0;
        for (Config config : this.configs) {
            size += config.size();
        }
        return size;
    }

    public boolean isEmpty() {
        for (Config config : this.configs) {
            if (config.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(Object key) {
        for (Config config : this.configs) {
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        for (Config config : this.configs) {
            if (!config.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        for (Config config : this.configs) {
            Object v = config.get(key);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public void clear() {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.entrySet().iterator();
    }

    public Set<String> keySet() {
        HashSet<String> entries = new HashSet<String>();
        for (Config config : this.configs) {
            entries.addAll(config.keySet());
        }
        return entries;
    }

    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Config config : this.configs) {
            values.addAll(config.values());
        }
        return values;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        for (Config config : this.configs) {
            entries.addAll(config.entrySet());
        }
        return entries;
    }

    public boolean containsProperty(String key) {
        return this.containsKey(key);
    }

    public String getProperty(String key, String defaultValue) {
        String v = this.getProperty(key, String.class);
        return !GrailsStringUtils.isBlank(v) ? v : defaultValue;
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        for (Config config : this.configs) {
            Object v = config.getProperty(key, targetType);
            if (v == null) continue;
            return (T)v;
        }
        return null;
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        T v = this.getProperty(key, targetType);
        return v != null ? v : defaultValue;
    }

    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetType) {
        String className = this.getProperty(key, String.class);
        if (!GrailsStringUtils.isBlank(className)) {
            try {
                Class clazz = ClassUtils.forName((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
                if (clazz != targetType) {
                    throw new NavigableMapConfig.ClassConversionException(clazz, targetType);
                }
                return clazz;
            }
            catch (Exception e) {
                throw new NavigableMapConfig.ClassConversionException(className, targetType, e);
            }
        }
        throw new IllegalStateException("Value for $key cannot be resolved");
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.getProperty(key);
        if (GrailsStringUtils.isBlank(value)) {
            throw new IllegalStateException("Value for key [$key] cannot be resolved");
        }
        return value;
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getProperty(key, targetType);
        if (value == null) {
            throw new IllegalStateException("Value for key [$key] cannot be resolved");
        }
        return value;
    }

    public String resolvePlaceholders(String text) {
        throw new UnsupportedOperationException("Config cannot be used to resolve placeholders");
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Config cannot be used to resolve placeholders");
    }

    public String getProperty(String key) {
        return this.getProperty(key, String.class);
    }
}

