/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.QueryValidationException;

public class GeoDistanceQueryBuilder
extends AbstractQueryBuilder<GeoDistanceQueryBuilder> {
    public static final String NAME = "geo_distance";
    public static final DistanceUnit DEFAULT_DISTANCE_UNIT = DistanceUnit.DEFAULT;
    public static final GeoDistance DEFAULT_GEO_DISTANCE = GeoDistance.ARC;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    private static final ParseField DISTANCE_FIELD = new ParseField("distance", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private double distance;
    private GeoPoint center = new GeoPoint(Double.NaN, Double.NaN);
    private GeoDistance geoDistance = GeoDistance.ARC;
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private boolean ignoreUnmapped = false;

    public GeoDistanceQueryBuilder(String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("fieldName must not be null or empty");
        }
        this.fieldName = fieldName;
    }

    public GeoDistanceQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.distance = in.readDouble();
        this.validationMethod = GeoValidationMethod.readFromStream(in);
        this.center = in.readGeoPoint();
        if (in.getVersion().before(Version.V_6_0_0_alpha1)) {
            in.readOptionalString();
        }
        this.geoDistance = GeoDistance.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeDouble(this.distance);
        this.validationMethod.writeTo(out);
        out.writeGeoPoint(this.center);
        if (out.getVersion().before(Version.V_6_0_0_alpha1)) {
            out.writeOptionalString(null);
        }
        this.geoDistance.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoDistanceQueryBuilder point(GeoPoint point) {
        if (point == null) {
            throw new IllegalArgumentException("center point must not be null");
        }
        this.center = point;
        return this;
    }

    public GeoDistanceQueryBuilder point(double lat, double lon) {
        this.center = new GeoPoint(lat, lon);
        return this;
    }

    public GeoPoint point() {
        return this.center;
    }

    public GeoDistanceQueryBuilder distance(String distance) {
        return this.distance(distance, DistanceUnit.DEFAULT);
    }

    public GeoDistanceQueryBuilder distance(String distance, DistanceUnit unit) {
        if (Strings.isEmpty(distance)) {
            throw new IllegalArgumentException("distance must not be null or empty");
        }
        if (unit == null) {
            throw new IllegalArgumentException("distance unit must not be null");
        }
        double newDistance = DistanceUnit.parse(distance, unit, DistanceUnit.DEFAULT);
        if (newDistance <= 0.0) {
            throw new IllegalArgumentException("distance must be greater than zero");
        }
        this.distance = newDistance;
        return this;
    }

    public GeoDistanceQueryBuilder distance(double distance, DistanceUnit unit) {
        return this.distance(Double.toString(distance), unit);
    }

    public double distance() {
        return this.distance;
    }

    public GeoDistanceQueryBuilder geohash(String geohash) {
        if (Strings.isEmpty(geohash)) {
            throw new IllegalArgumentException("geohash must not be null or empty");
        }
        this.center.resetFromGeoHash(geohash);
        return this;
    }

    public GeoDistanceQueryBuilder geoDistance(GeoDistance geoDistance) {
        if (geoDistance == null) {
            throw new IllegalArgumentException("geoDistance must not be null");
        }
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public void setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoDistanceQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected Query doToQuery(QueryShardContext shardContext) throws IOException {
        MappedFieldType fieldType = shardContext.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(shardContext, "failed to find geo_point field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(shardContext, "field [" + this.fieldName + "] is not a geo_point field", new Object[0]);
        }
        QueryValidationException exception = this.checkLatLon();
        if (exception != null) {
            throw new QueryShardException(shardContext, "couldn't validate latitude/ longitude values", exception, new Object[0]);
        }
        if (GeoValidationMethod.isCoerce(this.validationMethod)) {
            GeoUtils.normalizePoint(this.center, true, true);
        }
        Query query = LatLonPoint.newDistanceQuery((String)fieldType.name(), (double)this.center.lat(), (double)this.center.lon(), (double)this.distance);
        if (fieldType.hasDocValues()) {
            Query dvQuery = LatLonDocValuesField.newSlowDistanceQuery((String)fieldType.name(), (double)this.center.lat(), (double)this.center.lon(), (double)this.distance);
            query = new IndexOrDocValuesQuery(query, dvQuery);
        }
        return query;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(this.fieldName).value(this.center.lon()).value(this.center.lat()).endArray();
        builder.field(DISTANCE_FIELD.getPreferredName(), this.distance);
        builder.field(DISTANCE_TYPE_FIELD.getPreferredName(), this.geoDistance.name().toLowerCase(Locale.ROOT));
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), this.validationMethod);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static GeoDistanceQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        GeoPoint point = new GeoPoint(Double.NaN, Double.NaN);
        String fieldName = null;
        Object vDistance = null;
        DistanceUnit unit = DEFAULT_DISTANCE_UNIT;
        GeoDistance geoDistance = DEFAULT_GEO_DISTANCE;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                fieldName = currentFieldName;
                GeoUtils.parseGeoPoint(parser, point);
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                GeoDistanceQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                String currentName = parser.currentName();
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (currentName.equals("lat")) {
                        point.resetLat(parser.doubleValue());
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        point.resetLon(parser.doubleValue());
                        continue;
                    }
                    if (currentName.equals("geohash")) {
                        point.resetFromGeoHash(parser.text());
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[geo_distance] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (DISTANCE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    vDistance = parser.text();
                    continue;
                }
                vDistance = parser.numberValue();
                continue;
            }
            if (UNIT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (DISTANCE_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                point.resetLat(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                point.resetLon(parser.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lon".length());
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                validationMethod = GeoValidationMethod.fromString(parser.text());
                continue;
            }
            if (fieldName == null) {
                point.resetFromString(parser.text());
                fieldName = currentFieldName;
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", NAME, currentFieldName);
        }
        if (vDistance == null) {
            throw new ParsingException(parser.getTokenLocation(), "geo_distance requires 'distance' to be specified", new Object[0]);
        }
        GeoDistanceQueryBuilder qb = new GeoDistanceQueryBuilder(fieldName);
        if (vDistance instanceof Number) {
            qb.distance(((Number)vDistance).doubleValue(), unit);
        } else {
            qb.distance((String)vDistance, unit);
        }
        qb.point(point);
        if (validationMethod != null) {
            qb.setValidationMethod(validationMethod);
        }
        qb.geoDistance(geoDistance);
        qb.boost(boost);
        qb.queryName(queryName);
        qb.ignoreUnmapped(ignoreUnmapped);
        return qb;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.center, this.geoDistance, this.distance, this.validationMethod, this.ignoreUnmapped);
    }

    @Override
    protected boolean doEquals(GeoDistanceQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && this.distance == other.distance && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.center, other.center) && Objects.equals(this.geoDistance, other.geoDistance) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    private QueryValidationException checkLatLon() {
        if (GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            return null;
        }
        QueryValidationException validationException = null;
        if (!GeoUtils.isValidLatitude(this.center.getLat())) {
            validationException = this.addValidationError("center point latitude is invalid: " + this.center.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(this.center.getLon())) {
            validationException = this.addValidationError("center point longitude is invalid: " + this.center.getLon(), validationException);
        }
        return validationException;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

