/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

public class ActionListenerResponseHandler<Response extends TransportResponse>
implements TransportResponseHandler<Response> {
    private final ActionListener<? super Response> listener;
    private final Supplier<Response> responseSupplier;

    public ActionListenerResponseHandler(ActionListener<? super Response> listener, Supplier<Response> responseSupplier) {
        this.listener = Objects.requireNonNull(listener);
        this.responseSupplier = Objects.requireNonNull(responseSupplier);
    }

    @Override
    public void handleResponse(Response response) {
        this.listener.onResponse(response);
    }

    @Override
    public void handleException(TransportException e) {
        this.listener.onFailure(e);
    }

    @Override
    public Response newInstance() {
        return (Response)((TransportResponse)this.responseSupplier.get());
    }

    @Override
    public String executor() {
        return "same";
    }
}

