/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.WriteableIngestDocument;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.ingest.IngestDocument;

public final class SimulateDocumentBaseResult
implements SimulateDocumentResult {
    private final WriteableIngestDocument ingestDocument;
    private final Exception failure;

    public SimulateDocumentBaseResult(IngestDocument ingestDocument) {
        this.ingestDocument = new WriteableIngestDocument(ingestDocument);
        this.failure = null;
    }

    public SimulateDocumentBaseResult(Exception failure) {
        this.ingestDocument = null;
        this.failure = failure;
    }

    public SimulateDocumentBaseResult(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.ingestDocument = null;
            this.failure = in.readException();
        } else {
            this.ingestDocument = new WriteableIngestDocument(in);
            this.failure = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.failure == null) {
            out.writeBoolean(false);
            this.ingestDocument.writeTo(out);
        } else {
            out.writeBoolean(true);
            out.writeException(this.failure);
        }
    }

    public IngestDocument getIngestDocument() {
        if (this.ingestDocument == null) {
            return null;
        }
        return this.ingestDocument.getIngestDocument();
    }

    public Exception getFailure() {
        return this.failure;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.failure == null) {
            this.ingestDocument.toXContent(builder, params);
        } else {
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
        }
        builder.endObject();
        return builder;
    }
}

