/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.time;

import accessories.plugins.time.JCalendar;
import accessories.plugins.time.JDayChooser;
import accessories.plugins.time.JMonthChooser;
import accessories.plugins.time.JYearChooser;
import freemind.main.Resources;
import freemind.main.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tests.freemind.FreeMindMainMock;

public class JTripleCalendar
extends JPanel
implements PropertyChangeListener {
    private JCalendar calendarWidget;
    private JLabel leftLabel;
    private JLabel rightLabel;
    private JInfoPanel leftPanel;
    private JInfoPanel rightPanel;

    public JTripleCalendar() {
        this.setName("JTripleCalendar");
        GridLayout gridLayout = new GridLayout(3, 1);
        gridLayout.setHgap(50);
        this.setLayout(gridLayout);
        this.leftPanel = this.createInfoPanel();
        this.leftPanel.getCalendarWidget().addPropertyChangeListener(this);
        this.rightPanel = this.createInfoPanel();
        this.rightPanel.getCalendarWidget().addPropertyChangeListener(this);
        this.add(this.leftPanel);
        this.calendarWidget = new JCalendar();
        this.calendarWidget.addPropertyChangeListener(this);
        this.add(this.calendarWidget);
        this.add(this.rightPanel);
    }

    private JInfoPanel createInfoPanel() {
        JInfoPanel panel = new JInfoPanel();
        return panel;
    }

    public static void main(String[] args) {
        Resources.createInstance(new FreeMindMainMock());
        final JFrame frame = new JFrame("JTripleCalendar");
        frame.setDefaultCloseOperation(2);
        final JTripleCalendar jcalendar = new JTripleCalendar();
        frame.getContentPane().add(jcalendar);
        frame.pack();
        frame.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                jcalendar.getDayChooser().getSelectedDay().requestFocus();
                frame.removeWindowFocusListener(this);
            }
        });
        frame.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.calendarWidget) {
            Calendar gregorianCalendar = (Calendar)this.calendarWidget.getCalendar().clone();
            this.propagateDate(gregorianCalendar);
        } else if (Tools.safeEquals(evt.getPropertyName(), "day")) {
            this.checkForDateChange(evt, this.leftPanel);
            this.checkForDateChange(evt, this.rightPanel);
        }
    }

    public void checkForDateChange(PropertyChangeEvent evt, JInfoPanel pPanel) {
        if (evt.getSource() == pPanel.getCalendarWidget()) {
            Calendar gregorianCalendar = (Calendar)pPanel.getCalendar().clone();
            gregorianCalendar.set(5, (Integer)evt.getNewValue());
            this.calendarWidget.setCalendar(gregorianCalendar);
            this.propagateDate(gregorianCalendar);
        }
    }

    public void propagateDate(Calendar gregorianCalendar) {
        gregorianCalendar.add(2, -1);
        this.leftPanel.setDate(gregorianCalendar);
        gregorianCalendar.add(2, 2);
        this.rightPanel.setDate(gregorianCalendar);
    }

    public Calendar getCalendar() {
        return this.calendarWidget.getCalendar();
    }

    public Date getDate() {
        return this.calendarWidget.getDate();
    }

    public JDayChooser getDayChooser() {
        return this.calendarWidget.getDayChooser();
    }

    public void setDate(Date date) {
        this.calendarWidget.setDate(date);
    }

    public void setCalendar(Calendar c) {
        this.calendarWidget.setCalendar(c);
    }

    public JYearChooser getYearChooser() {
        return this.calendarWidget.getYearChooser();
    }

    private static class JInfoPanel
    extends JPanel {
        private JDayChooser dayChooser;
        private JMonthChooser monthChooser;
        private JYearChooser yearChooser;

        public JInfoPanel() {
            this.setLayout(new BorderLayout());
            JPanel monthYearPanel = new JPanel();
            monthYearPanel.setLayout(new BorderLayout());
            this.monthChooser = new JMonthChooser();
            this.monthChooser.setEnabled(false);
            this.yearChooser = new JYearChooser();
            this.yearChooser.setEnabled(false);
            monthYearPanel.add((Component)this.monthChooser, "West");
            monthYearPanel.add((Component)this.yearChooser, "Center");
            this.dayChooser = new JDayChooser(true){

                @Override
                protected void init() {
                    super.init();
                    this.selectedColor = this.oldDayBackgroundColor;
                }

                @Override
                public void addListeners(int index) {
                    this.days[index].addActionListener(this);
                    this.days[index].setFocusable(false);
                }
            };
            this.dayChooser.setEnabled(true);
            this.dayChooser.setAlwaysFireDayProperty(true);
            this.add((Component)monthYearPanel, "North");
            this.add((Component)this.dayChooser, "Center");
        }

        public void setDate(Calendar calendar) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            this.monthChooser.setMonth(month);
            this.yearChooser.setYear(year);
            this.dayChooser.setYear(year);
            this.dayChooser.setMonth(month);
            this.dayChooser.setEnabled(true);
        }

        public Calendar getCalendar() {
            return this.dayChooser.calendar;
        }

        public JDayChooser getCalendarWidget() {
            return this.dayChooser;
        }
    }
}

