#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.6.0
id: esqueleto-2.6.0-3yhempdV95NJvhHQ9Z2VfH
key: esqueleto-2.6.0-3yhempdV95NJvhHQ9Z2VfH
license: BSD-3-Clause
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
author: Felipe Lessa
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.
category: Database
abi: 0f14bc367be8e0353f1fa8a8b985f133
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql Database.Esqueleto.MySQL
    Database.Esqueleto.PostgreSQL Database.Esqueleto.SQLite
hidden-modules: Database.Esqueleto.Internal.PersistentImport
                Paths_esqueleto
import-dirs: /usr/lib/ghc-8.4.3/site-local/esqueleto-2.6.0
library-dirs: /usr/lib/ghc-8.4.3/site-local/esqueleto-2.6.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/esqueleto-2.6.0
hs-libraries: HSesqueleto-2.6.0-3yhempdV95NJvhHQ9Z2VfH
depends:
    base-4.11.1.0 blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG
    bytestring-0.10.8.2 conduit-1.3.0.3-JvPBE4EhGj9IqkHmyEaMOO
    monad-logger-0.3.29-sagUch8hi92Rlu1vof3aQ
    persistent-2.8.2-BXbtGajRvLEIUcTNH1SKx5
    resourcet-1.2.1-LmgqSpZgtYc1CYRXUZoy4I
    tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO text-1.2.3.0 time-1.8.0.2
    transformers-0.5.5.0 unliftio-0.2.7.0-7ZRg6vBOAnJKhVzuKPAekD
    unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             blaze-html-0.9.1.1-ImJwSrLxU02EzwI2h3NYFG=c53bb3bf02513bb30eb5ce3eb528e263
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             conduit-1.3.0.3-JvPBE4EhGj9IqkHmyEaMOO=edcb68965d1c4f937af777b49e45f52f
             monad-logger-0.3.29-sagUch8hi92Rlu1vof3aQ=c16a63cb405cd2ea957452c7c311c295
             persistent-2.8.2-BXbtGajRvLEIUcTNH1SKx5=cbb6e82c79fe6300e80f22bb9e1605f3
             resourcet-1.2.1-LmgqSpZgtYc1CYRXUZoy4I=3fbb0f35b28cf76949df3af0a83627ff
             tagged-0.8.6-8akQ1aZG2N2GFJpoB5eGXO=92d44612a64675b8cba7ce44e507a395
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             unliftio-0.2.7.0-7ZRg6vBOAnJKhVzuKPAekD=8fd70228491f8061a2db66cb334cc156
             unordered-containers-0.2.9.0-IEc9LFcTDjK6w3ap4NqwQu=5b052eced98346d45f3db03378f2841d
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

