/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class HyperChemReader
extends AtomSetCollectionReader {
    private int atomIndex;

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.length() == 0 || this.line.charAt(0) == ';') {
            return true;
        }
        if (this.line.startsWith("mol ")) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.processMol();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith("atom ")) {
            this.processAtom();
            return true;
        }
        if (this.line.startsWith("endmol ")) {
            this.applySymmetryAndSetTrajectory();
            return true;
        }
        return true;
    }

    private void processMol() throws Exception {
        this.asc.newAtomSet();
        String molName = this.getMolName();
        this.asc.setAtomSetName(molName);
        this.atomIndex = 0;
        this.baseAtomIndex = this.asc.ac;
    }

    private String getMolName() {
        this.parseTokenStr(this.line);
        this.parseToken();
        return this.parseToken();
    }

    private void processAtom() throws Exception {
        int fileAtomNumber = this.parseIntAt(this.line, 5);
        if (fileAtomNumber - 1 != this.atomIndex) {
            throw new Exception("bad atom number sequence ... expected:" + (this.atomIndex + 1) + " found:" + fileAtomNumber);
        }
        Atom atom = this.asc.addNewAtom();
        this.parseToken();
        atom.elementSymbol = this.parseToken();
        this.parseToken();
        this.parseToken();
        atom.partialCharge = this.parseFloat();
        this.setAtomCoordXYZ(atom, this.parseFloat(), this.parseFloat(), this.parseFloat());
        int bondCount = this.parseInt();
        for (int i = 0; i < bondCount; ++i) {
            int bondOrder;
            int otherAtomNumber = this.parseInt();
            String bondTypeToken = this.parseToken();
            if (otherAtomNumber > this.atomIndex) continue;
            switch (bondTypeToken.charAt(0)) {
                case 's': {
                    bondOrder = 1;
                    break;
                }
                case 'd': {
                    bondOrder = 2;
                    break;
                }
                case 't': {
                    bondOrder = 3;
                    break;
                }
                case 'a': {
                    bondOrder = 515;
                    break;
                }
                default: {
                    throw new Exception("unrecognized bond type:" + bondTypeToken + " atom #" + fileAtomNumber);
                }
            }
            this.asc.addNewBondWithOrder(this.baseAtomIndex + this.atomIndex, this.baseAtomIndex + otherAtomNumber - 1, bondOrder);
        }
        ++this.atomIndex;
    }
}

