/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.aux;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.aux.AuxCommand;
import com.dickimawbooks.texparserlib.aux.AuxData;
import com.dickimawbooks.texparserlib.aux.AuxIgnoreable;
import com.dickimawbooks.texparserlib.generic.DefaultTeXParserListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Vector;

public class AuxParser
extends DefaultTeXParserListener
implements Writeable {
    private Vector<AuxData> auxData;
    private TeXApp texApp;
    private Charset charset = null;

    public AuxParser(TeXApp teXApp) throws IOException {
        this(teXApp, null);
    }

    public AuxParser(TeXApp teXApp, Charset charset) throws IOException {
        super(null);
        this.texApp = teXApp;
        this.charset = charset;
        this.setWriteable(this);
        this.auxData = new Vector();
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }

    public TeXParser parseAuxFile(File file) throws IOException {
        return this.parseAuxFile(file, null);
    }

    public TeXParser parseAuxFile(File file, Charset charset) throws IOException {
        if (charset != null) {
            this.charset = charset;
        }
        TeXParser teXParser = new TeXParser(this);
        int n = teXParser.getCatCode(64);
        teXParser.setCatCode(64, 11);
        teXParser.parse(file);
        teXParser.setCatCode(64, n);
        return teXParser;
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.addAuxCommand("newlabel", 2);
        this.addAuxCommand("bibstyle", 1);
        this.addAuxCommand("citation", 1);
        this.addAuxCommand("bibdata", 1);
        this.addAuxCommand("bibcite", 2);
        this.putControlSequence(new AuxIgnoreable("providecommand", true, new boolean[]{true, false, true}));
    }

    public void addAuxCommand(String string, int n) {
        this.putControlSequence(new AuxCommand(string, n));
    }

    @Override
    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = super.getControlSequence(string);
        return controlSequence instanceof AuxCommand || controlSequence instanceof AuxIgnoreable ? controlSequence : new AuxIgnoreable(string);
    }

    @Override
    public Writeable getWriteable() {
        return this;
    }

    @Override
    public void write(String string) throws IOException {
    }

    @Override
    public void writeln(String string) throws IOException {
    }

    @Override
    public void write(char c) throws IOException {
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file) throws IOException {
        this.getTeXApp().message(this.getTeXApp().getMessage("message.reading", file));
    }

    public void addAuxData(AuxData auxData) {
        this.auxData.add(auxData);
    }

    public Vector<AuxData> getAuxData(String string) {
        Vector<AuxData> vector = new Vector<AuxData>();
        for (AuxData auxData : this.auxData) {
            if (!auxData.getName().equals(string)) continue;
            vector.add(auxData);
        }
        return vector;
    }

    public Vector<AuxData> getAuxData() {
        return this.auxData;
    }

    @Override
    public Charset getCharSet() {
        return this.charset;
    }

    @Override
    public float emToPt(float f) {
        this.getTeXApp().warning(this.getParser(), "Can't convert from em to pt, no font information loaded");
        return 9.5f * f;
    }

    @Override
    public float exToPt(float f) {
        this.getTeXApp().warning(this.getParser(), "Can't convert from ex to pt, no font information loaded");
        return 4.4f * f;
    }
}

