/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.watcher.WatcherField;
import org.elasticsearch.xpack.core.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.core.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.core.watcher.condition.ConditionFactory;
import org.elasticsearch.xpack.core.watcher.condition.ConditionRegistry;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;
import org.elasticsearch.xpack.core.watcher.history.HistoryStoreField;
import org.elasticsearch.xpack.core.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.core.watcher.transform.TransformRegistry;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.EncryptSensitiveDataBootstrapCheck;
import org.elasticsearch.xpack.watcher.WatcherFeatureSet;
import org.elasticsearch.xpack.watcher.WatcherIndexingListener;
import org.elasticsearch.xpack.watcher.WatcherLifeCycleService;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.actions.email.EmailActionFactory;
import org.elasticsearch.xpack.watcher.actions.hipchat.HipChatActionFactory;
import org.elasticsearch.xpack.watcher.actions.index.IndexActionFactory;
import org.elasticsearch.xpack.watcher.actions.jira.JiraActionFactory;
import org.elasticsearch.xpack.watcher.actions.logging.LoggingActionFactory;
import org.elasticsearch.xpack.watcher.actions.pagerduty.PagerDutyActionFactory;
import org.elasticsearch.xpack.watcher.actions.slack.SlackActionFactory;
import org.elasticsearch.xpack.watcher.actions.webhook.WebhookActionFactory;
import org.elasticsearch.xpack.watcher.common.http.HttpClient;
import org.elasticsearch.xpack.watcher.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.watcher.common.http.HttpSettings;
import org.elasticsearch.xpack.watcher.common.http.auth.HttpAuthFactory;
import org.elasticsearch.xpack.watcher.common.http.auth.HttpAuthRegistry;
import org.elasticsearch.xpack.watcher.common.http.auth.basic.BasicAuthFactory;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.condition.ArrayCompareCondition;
import org.elasticsearch.xpack.watcher.condition.CompareCondition;
import org.elasticsearch.xpack.watcher.condition.InternalAlwaysCondition;
import org.elasticsearch.xpack.watcher.condition.NeverCondition;
import org.elasticsearch.xpack.watcher.condition.ScriptCondition;
import org.elasticsearch.xpack.watcher.execution.AsyncTriggerEventConsumer;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.execution.InternalWatchExecutor;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatchStore;
import org.elasticsearch.xpack.watcher.execution.WatchExecutor;
import org.elasticsearch.xpack.watcher.history.HistoryStore;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.InputRegistry;
import org.elasticsearch.xpack.watcher.input.chain.ChainInputFactory;
import org.elasticsearch.xpack.watcher.input.http.HttpInputFactory;
import org.elasticsearch.xpack.watcher.input.none.NoneInputFactory;
import org.elasticsearch.xpack.watcher.input.search.SearchInputFactory;
import org.elasticsearch.xpack.watcher.input.simple.SimpleInputFactory;
import org.elasticsearch.xpack.watcher.input.transform.TransformInputFactory;
import org.elasticsearch.xpack.watcher.notification.email.Account;
import org.elasticsearch.xpack.watcher.notification.email.EmailService;
import org.elasticsearch.xpack.watcher.notification.email.HtmlSanitizer;
import org.elasticsearch.xpack.watcher.notification.email.attachment.DataAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentsParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.HttpEmailAttachementParser;
import org.elasticsearch.xpack.watcher.notification.email.attachment.ReportingAttachmentParser;
import org.elasticsearch.xpack.watcher.notification.email.support.BodyPartSource;
import org.elasticsearch.xpack.watcher.notification.hipchat.HipChatService;
import org.elasticsearch.xpack.watcher.notification.jira.JiraService;
import org.elasticsearch.xpack.watcher.notification.pagerduty.PagerDutyService;
import org.elasticsearch.xpack.watcher.notification.slack.SlackService;
import org.elasticsearch.xpack.watcher.rest.action.RestAckWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestActivateWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestDeleteWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestExecuteWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestGetWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestHijackOperationAction;
import org.elasticsearch.xpack.watcher.rest.action.RestPutWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestWatchServiceAction;
import org.elasticsearch.xpack.watcher.rest.action.RestWatcherStatsAction;
import org.elasticsearch.xpack.watcher.support.WatcherIndexTemplateRegistry;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransformFactory;
import org.elasticsearch.xpack.watcher.transform.search.SearchTransformFactory;
import org.elasticsearch.xpack.watcher.transport.actions.ack.TransportAckWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.activate.TransportActivateWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.delete.TransportDeleteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.execute.TransportExecuteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.get.TransportGetWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.put.TransportPutWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.service.TransportWatcherServiceAction;
import org.elasticsearch.xpack.watcher.transport.actions.stats.OldTransportWatcherStatsAction;
import org.elasticsearch.xpack.watcher.transport.actions.stats.OldWatcherStatsAction;
import org.elasticsearch.xpack.watcher.transport.actions.stats.TransportWatcherStatsAction;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.trigger.manual.ManualTriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.DailySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.HourlySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.IntervalSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.MonthlySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleRegistry;
import org.elasticsearch.xpack.watcher.trigger.schedule.WeeklySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.YearlySchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.engine.TickerScheduleTriggerEngine;
import org.elasticsearch.xpack.watcher.watch.WatchParser;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Watcher
extends Plugin
implements ActionPlugin,
ScriptPlugin {
    @Deprecated
    public static final Setting<String> INDEX_WATCHER_TEMPLATE_VERSION_SETTING = new Setting("index.xpack.watcher.template.version", "", Function.identity(), new Setting.Property[]{Setting.Property.IndexScope});
    public static final Setting<Boolean> ENCRYPT_SENSITIVE_DATA_SETTING = Setting.boolSetting((String)"xpack.watcher.encrypt_sensitive_data", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> MAX_STOP_TIMEOUT_SETTING = Setting.timeSetting((String)"xpack.watcher.stop.timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Set<String> HEADER_FILTERS = new HashSet<String>(Arrays.asList("es-security-runas-user", "_xpack_security_authentication"));
    public static final ScriptContext<SearchScript.Factory> SCRIPT_SEARCH_CONTEXT = new ScriptContext("xpack", SearchScript.Factory.class);
    public static final ScriptContext<ExecutableScript.Factory> SCRIPT_EXECUTABLE_CONTEXT = new ScriptContext("xpack_executable", ExecutableScript.Factory.class);
    public static final ScriptContext<TemplateScript.Factory> SCRIPT_TEMPLATE_CONTEXT = new ScriptContext("xpack_template", TemplateScript.Factory.class);
    private static final Logger logger = Loggers.getLogger(Watcher.class);
    private WatcherIndexingListener listener;
    private HttpClient httpClient;
    protected final Settings settings;
    protected final boolean transportClient;
    protected final boolean enabled;
    protected final Environment env;

    public Watcher(Settings settings) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.WATCHER_ENABLED.get(settings);
        this.transportClient = XPackPlugin.transportClientMode((Settings)settings);
        Environment environment = this.env = this.transportClient ? null : new Environment(settings, null);
        if (this.enabled && !this.transportClient) {
            Watcher.validAutoCreateIndex(settings, logger);
        }
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        CryptoService cryptoService;
        if (!this.enabled) {
            return Collections.emptyList();
        }
        BodyPartSource.init();
        Account.init();
        try {
            cryptoService = (Boolean)ENCRYPT_SENSITIVE_DATA_SETTING.get(this.settings) != false ? new CryptoService(this.settings) : null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        new WatcherIndexTemplateRegistry(this.settings, clusterService, threadPool, client);
        HashMap<String, HttpAuthFactory> httpAuthFactories = new HashMap<String, HttpAuthFactory>();
        httpAuthFactories.put("basic", new BasicAuthFactory(cryptoService));
        HttpAuthRegistry httpAuthRegistry = new HttpAuthRegistry(httpAuthFactories);
        HttpRequestTemplate.Parser httpTemplateParser = new HttpRequestTemplate.Parser(httpAuthRegistry);
        this.httpClient = new HttpClient(this.settings, httpAuthRegistry, this.getSslService());
        EmailService emailService = new EmailService(this.settings, cryptoService, clusterService.getClusterSettings());
        HipChatService hipChatService = new HipChatService(this.settings, this.httpClient, clusterService.getClusterSettings());
        JiraService jiraService = new JiraService(this.settings, this.httpClient, clusterService.getClusterSettings());
        SlackService slackService = new SlackService(this.settings, this.httpClient, clusterService.getClusterSettings());
        PagerDutyService pagerDutyService = new PagerDutyService(this.settings, this.httpClient, clusterService.getClusterSettings());
        TextTemplateEngine templateEngine = new TextTemplateEngine(this.settings, scriptService);
        HashMap<String, EmailAttachmentParser> emailAttachmentParsers = new HashMap<String, EmailAttachmentParser>();
        emailAttachmentParsers.put("http", new HttpEmailAttachementParser(this.httpClient, httpTemplateParser, templateEngine));
        emailAttachmentParsers.put("data", new DataAttachmentParser());
        emailAttachmentParsers.put("reporting", new ReportingAttachmentParser(this.settings, this.httpClient, templateEngine, httpAuthRegistry));
        EmailAttachmentsParser emailAttachmentsParser = new EmailAttachmentsParser(emailAttachmentParsers);
        HashMap<String, ConditionFactory> parsers = new HashMap<String, ConditionFactory>();
        parsers.put("always", (c, id, p) -> InternalAlwaysCondition.parse(id, p));
        parsers.put("never", (c, id, p) -> NeverCondition.parse(id, p));
        parsers.put("array_compare", ArrayCompareCondition::parse);
        parsers.put("compare", CompareCondition::parse);
        parsers.put("script", (c, id, p) -> ScriptCondition.parse(scriptService, id, p));
        ConditionRegistry conditionRegistry = new ConditionRegistry(Collections.unmodifiableMap(parsers), this.getClock());
        HashMap<String, TransformFactory> transformFactories = new HashMap<String, TransformFactory>();
        transformFactories.put("script", new ScriptTransformFactory(this.settings, scriptService));
        transformFactories.put("search", new SearchTransformFactory(this.settings, client, xContentRegistry, scriptService));
        TransformRegistry transformRegistry = new TransformRegistry(this.settings, Collections.unmodifiableMap(transformFactories));
        HashMap<String, ActionFactory> actionFactoryMap = new HashMap<String, ActionFactory>();
        actionFactoryMap.put("email", new EmailActionFactory(this.settings, emailService, templateEngine, emailAttachmentsParser));
        actionFactoryMap.put("webhook", new WebhookActionFactory(this.settings, this.httpClient, httpTemplateParser, templateEngine));
        actionFactoryMap.put("index", new IndexActionFactory(this.settings, client));
        actionFactoryMap.put("logging", new LoggingActionFactory(this.settings, templateEngine));
        actionFactoryMap.put("hipchat", new HipChatActionFactory(this.settings, templateEngine, hipChatService));
        actionFactoryMap.put("jira", new JiraActionFactory(this.settings, templateEngine, jiraService));
        actionFactoryMap.put("slack", new SlackActionFactory(this.settings, templateEngine, slackService));
        actionFactoryMap.put("pagerduty", new PagerDutyActionFactory(this.settings, templateEngine, pagerDutyService));
        ActionRegistry registry = new ActionRegistry(actionFactoryMap, conditionRegistry, transformRegistry, this.getClock(), this.getLicenseState());
        HashMap<String, InputFactory> inputFactories = new HashMap<String, InputFactory>();
        inputFactories.put("search", new SearchInputFactory(this.settings, client, xContentRegistry, scriptService));
        inputFactories.put("simple", new SimpleInputFactory(this.settings));
        inputFactories.put("http", new HttpInputFactory(this.settings, this.httpClient, templateEngine, httpTemplateParser));
        inputFactories.put("none", new NoneInputFactory(this.settings));
        inputFactories.put("transform", new TransformInputFactory(this.settings, transformRegistry));
        InputRegistry inputRegistry = new InputRegistry(this.settings, inputFactories);
        inputFactories.put("chain", new ChainInputFactory(this.settings, inputRegistry));
        HistoryStore historyStore = new HistoryStore(this.settings, client);
        HashSet<Schedule.Parser> scheduleParsers = new HashSet<Schedule.Parser>();
        scheduleParsers.add(new CronSchedule.Parser());
        scheduleParsers.add(new DailySchedule.Parser());
        scheduleParsers.add(new HourlySchedule.Parser());
        scheduleParsers.add(new IntervalSchedule.Parser());
        scheduleParsers.add(new MonthlySchedule.Parser());
        scheduleParsers.add(new WeeklySchedule.Parser());
        scheduleParsers.add(new YearlySchedule.Parser());
        ScheduleRegistry scheduleRegistry = new ScheduleRegistry(scheduleParsers);
        ManualTriggerEngine manualTriggerEngine = new ManualTriggerEngine();
        TriggerEngine configuredTriggerEngine = this.getTriggerEngine(this.getClock(), scheduleRegistry);
        HashSet<TriggerEngine> triggerEngines = new HashSet<TriggerEngine>();
        triggerEngines.add(manualTriggerEngine);
        triggerEngines.add(configuredTriggerEngine);
        TriggerService triggerService = new TriggerService(this.settings, triggerEngines);
        TriggeredWatch.Parser triggeredWatchParser = new TriggeredWatch.Parser(this.settings, triggerService);
        TriggeredWatchStore triggeredWatchStore = new TriggeredWatchStore(this.settings, client, triggeredWatchParser);
        WatcherSearchTemplateService watcherSearchTemplateService = new WatcherSearchTemplateService(this.settings, scriptService, xContentRegistry);
        WatchExecutor watchExecutor = this.getWatchExecutor(threadPool);
        WatchParser watchParser = new WatchParser(this.settings, triggerService, registry, inputRegistry, cryptoService, this.getClock());
        ExecutionService executionService = new ExecutionService(this.settings, historyStore, triggeredWatchStore, watchExecutor, this.getClock(), watchParser, clusterService, client);
        Consumer<Iterable<TriggerEvent>> triggerEngineListener = this.getTriggerEngineListener(executionService);
        triggerService.register(triggerEngineListener);
        WatcherService watcherService = new WatcherService(this.settings, triggerService, triggeredWatchStore, executionService, watchParser, client);
        WatcherLifeCycleService watcherLifeCycleService = new WatcherLifeCycleService(this.settings, threadPool, clusterService, watcherService);
        this.listener = new WatcherIndexingListener(this.settings, watchParser, this.getClock(), triggerService);
        clusterService.addListener((ClusterStateListener)this.listener);
        return Arrays.asList(new Object[]{registry, inputRegistry, historyStore, triggerService, triggeredWatchParser, watcherLifeCycleService, executionService, triggerEngineListener, watcherService, watchParser, configuredTriggerEngine, triggeredWatchStore, watcherSearchTemplateService, slackService, pagerDutyService, hipChatService});
    }

    protected TriggerEngine getTriggerEngine(Clock clock, ScheduleRegistry scheduleRegistry) {
        return new TickerScheduleTriggerEngine(this.settings, scheduleRegistry, clock);
    }

    protected WatchExecutor getWatchExecutor(ThreadPool threadPool) {
        return new InternalWatchExecutor(threadPool);
    }

    protected Consumer<Iterable<TriggerEvent>> getTriggerEngineListener(ExecutionService executionService) {
        return new AsyncTriggerEventConsumer(this.settings, executionService);
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> b.bind(Clock.class).toInstance((Object)this.getClock()));
        modules.add(b -> {
            XPackPlugin.bindFeatureSet((Binder)b, WatcherFeatureSet.class);
            if (this.transportClient || !this.enabled) {
                b.bind(WatcherService.class).toProvider(Providers.of(null));
            }
        });
        return modules;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(INDEX_WATCHER_TEMPLATE_VERSION_SETTING);
        settings.add(MAX_STOP_TIMEOUT_SETTING);
        settings.add(ExecutionService.DEFAULT_THROTTLE_PERIOD_SETTING);
        settings.add(TickerScheduleTriggerEngine.TICKER_INTERVAL_SETTING);
        settings.add(Setting.intSetting((String)"xpack.watcher.execution.scroll.size", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.intSetting((String)"xpack.watcher.watch.scroll.size", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(ENCRYPT_SENSITIVE_DATA_SETTING);
        settings.add(WatcherField.ENCRYPTION_KEY_SETTING);
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.bulk.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.index.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.actions.index.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.actions.bulk.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.index.rest.direct_access", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.input.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.transform.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.execution.scroll.timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(WatcherLifeCycleService.SETTING_REQUIRE_MANUAL_START);
        settings.addAll(SlackService.getSettings());
        settings.addAll(EmailService.getSettings());
        settings.addAll(HtmlSanitizer.getSettings());
        settings.addAll(HipChatService.getSettings());
        settings.addAll(JiraService.getSettings());
        settings.addAll(PagerDutyService.getSettings());
        settings.add(ReportingAttachmentParser.RETRIES_SETTING);
        settings.add(ReportingAttachmentParser.INTERVAL_SETTING);
        settings.addAll(HttpSettings.getSettings());
        CryptoService.addSettings(settings);
        return settings;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (this.enabled) {
            FixedExecutorBuilder builder = new FixedExecutorBuilder(settings, "watcher", Watcher.getWatcherThreadPoolSize(settings), 1000, "xpack.watcher.thread_pool");
            return Collections.singletonList(builder);
        }
        return Collections.emptyList();
    }

    static int getWatcherThreadPoolSize(Settings settings) {
        boolean isDataNode = (Boolean)Node.NODE_DATA_SETTING.get(settings);
        if (isDataNode) {
            int numberOfProcessors = EsExecutors.numberOfProcessors((Settings)settings);
            long size = Math.max(Math.min(5 * numberOfProcessors, 50), numberOfProcessors);
            return Math.toIntExact(size);
        }
        return 1;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)PutWatchAction.INSTANCE, TransportPutWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteWatchAction.INSTANCE, TransportDeleteWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetWatchAction.INSTANCE, TransportGetWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)WatcherStatsAction.INSTANCE, TransportWatcherStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)OldWatcherStatsAction.INSTANCE, OldTransportWatcherStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)AckWatchAction.INSTANCE, TransportAckWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ActivateWatchAction.INSTANCE, TransportActivateWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)WatcherServiceAction.INSTANCE, TransportWatcherServiceAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ExecuteWatchAction.INSTANCE, TransportExecuteWatchAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestPutWatchAction(settings, restController), new RestDeleteWatchAction(settings, restController), new RestWatcherStatsAction(settings, restController), new RestGetWatchAction(settings, restController), new RestWatchServiceAction(settings, restController), new RestAckWatchAction(settings, restController), new RestActivateWatchAction(settings, restController), new RestExecuteWatchAction(settings, restController), new RestHijackOperationAction(settings, restController)});
    }

    public void onIndexModule(IndexModule module) {
        if (!this.enabled || this.transportClient) {
            return;
        }
        assert (this.listener != null);
        if (module.getIndex().getName().startsWith(".watches")) {
            module.addIndexOperationListener((IndexingOperationListener)this.listener);
        }
    }

    static void validAutoCreateIndex(Settings settings, Logger logger) {
        String value = settings.get("action.auto_create_index");
        if (value == null) {
            return;
        }
        String errorMessage = LoggerMessageFormat.format((String)"the [action.auto_create_index] setting value [{}] is too restrictive. disable [action.auto_create_index] or set it to [{}, {}, {}*]", (Object[])new Object[]{value, ".watches", ".triggered_watches", ".watcher-history-"});
        if (Booleans.isFalse((String)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (Booleans.isTrue((String)value)) {
            return;
        }
        String[] matches = Strings.commaDelimitedListToStringArray((String)value);
        ArrayList<String> indices = new ArrayList<String>();
        indices.add(".watches");
        indices.add(".triggered_watches");
        DateTime now = new DateTime(DateTimeZone.UTC);
        indices.add(HistoryStoreField.getHistoryIndexNameForTime((DateTime)now));
        indices.add(HistoryStoreField.getHistoryIndexNameForTime((DateTime)now.plusDays(1)));
        indices.add(HistoryStoreField.getHistoryIndexNameForTime((DateTime)now.plusMonths(1)));
        indices.add(HistoryStoreField.getHistoryIndexNameForTime((DateTime)now.plusMonths(2)));
        indices.add(HistoryStoreField.getHistoryIndexNameForTime((DateTime)now.plusMonths(3)));
        indices.add(HistoryStoreField.getHistoryIndexNameForTime((DateTime)now.plusMonths(4)));
        indices.add(HistoryStoreField.getHistoryIndexNameForTime((DateTime)now.plusMonths(5)));
        indices.add(HistoryStoreField.getHistoryIndexNameForTime((DateTime)now.plusMonths(6)));
        for (String index : indices) {
            boolean matched = false;
            for (String match : matches) {
                char c = match.charAt(0);
                if (c == '-') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    throw new IllegalArgumentException(errorMessage);
                }
                if (c == '+') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    matched = true;
                    break;
                }
                if (!Regex.simpleMatch((String)match, (String)index)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            throw new IllegalArgumentException(errorMessage);
        }
        logger.warn("the [action.auto_create_index] setting is configured to be restrictive [{}].  for the next 6 months daily history indices are allowed to be created, but please make sure that any future history indices after 6 months with the pattern [.watcher-history-YYYY.MM.dd] are allowed to be created", (Object)value);
    }

    public UnaryOperator<Map<String, IndexTemplateMetaData>> getIndexTemplateMetaDataUpgrader() {
        return map -> {
            map.keySet().removeIf(name -> name.startsWith("watch_history_"));
            return map;
        };
    }

    public List<BootstrapCheck> getBootstrapChecks() {
        return Collections.singletonList(new EncryptSensitiveDataBootstrapCheck(this.env));
    }

    public List<ScriptContext> getContexts() {
        return Arrays.asList(SCRIPT_SEARCH_CONTEXT, SCRIPT_EXECUTABLE_CONTEXT, SCRIPT_TEMPLATE_CONTEXT);
    }

    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.httpClient});
    }
}

