/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class StoredScriptSource
extends AbstractDiffable<StoredScriptSource>
implements Writeable,
ToXContentObject {
    public static final ParseField SCRIPT_PARSE_FIELD = new ParseField("script", new String[0]);
    public static final ParseField TEMPLATE_PARSE_FIELD = new ParseField("template", new String[0]);
    public static final ParseField LANG_PARSE_FIELD = new ParseField("lang", new String[0]);
    public static final ParseField SOURCE_PARSE_FIELD = new ParseField("source", "code");
    public static final ParseField OPTIONS_PARSE_FIELD = new ParseField("options", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("stored script source", () -> new Builder());
    private final String lang;
    private final String source;
    private final Map<String, String> options;

    /*
     * Exception decompiling
     */
    public static StoredScriptSource parse(BytesReference content, XContentType xContentType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static StoredScriptSource fromXContent(XContentParser parser) {
        return StoredScriptSource.PARSER.apply(parser, null).build();
    }

    public static Diff<StoredScriptSource> readDiffFrom(StreamInput in) throws IOException {
        return StoredScriptSource.readDiffFrom(StoredScriptSource::new, in);
    }

    public StoredScriptSource(String source) {
        this.lang = null;
        this.source = Objects.requireNonNull(source);
        this.options = null;
    }

    public StoredScriptSource(String lang, String source, Map<String, String> options) {
        this.lang = Objects.requireNonNull(lang);
        this.source = Objects.requireNonNull(source);
        this.options = Collections.unmodifiableMap(Objects.requireNonNull(options));
    }

    public StoredScriptSource(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_5_3_0)) {
            this.lang = in.readString();
            this.source = in.readString();
            Map<String, Object> options = in.readMap();
            this.options = options;
        } else {
            this.lang = null;
            this.source = in.readBytesReference().utf8ToString();
            this.options = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeString(this.lang);
            out.writeString(this.source);
            Map<String, Object> options = this.options;
            out.writeMap(options);
        } else {
            out.writeBytesReference(new BytesArray(this.source));
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LANG_PARSE_FIELD.getPreferredName(), this.lang);
        builder.field(SOURCE_PARSE_FIELD.getPreferredName(), this.source);
        builder.field(OPTIONS_PARSE_FIELD.getPreferredName(), this.options);
        builder.endObject();
        return builder;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredScriptSource that = (StoredScriptSource)o;
        if (this.lang != null ? !this.lang.equals(that.lang) : that.lang != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return this.options != null ? this.options.equals(that.options) : that.options == null;
    }

    public int hashCode() {
        int result = this.lang != null ? this.lang.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StoredScriptSource{lang='" + this.lang + '\'' + ", source='" + this.source + '\'' + ", options=" + this.options + '}';
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static {
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setLang(x$0), LANG_PARSE_FIELD);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setSource(x$0), parser -> parser, SOURCE_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setOptions(x$0), XContentParser::mapStrings, OPTIONS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static final class Builder {
        private String lang;
        private String source;
        private Map<String, String> options = new HashMap<String, String>();

        private Builder() {
        }

        private void setLang(String lang) {
            this.lang = lang;
        }

        private void setSource(XContentParser parser) {
            try {
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    this.source = Strings.toString(builder.copyCurrentStructure(parser));
                    this.options.put("content_type", XContentType.JSON.mediaType());
                } else {
                    this.source = parser.text();
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void setOptions(Map<String, String> options) {
            this.options.putAll(options);
        }

        private StoredScriptSource build() {
            if (this.lang == null) {
                throw new IllegalArgumentException("must specify lang for stored script");
            }
            if (this.lang.isEmpty()) {
                throw new IllegalArgumentException("lang cannot be empty");
            }
            if (this.source == null) {
                throw new IllegalArgumentException("must specify source for stored script");
            }
            if (this.source.isEmpty()) {
                throw new IllegalArgumentException("source cannot be empty");
            }
            if (this.options.size() > 1 || this.options.size() == 1 && this.options.get("content_type") == null) {
                throw new IllegalArgumentException("illegal compiler options [" + this.options + "] specified");
            }
            return new StoredScriptSource(this.lang, this.source, this.options);
        }
    }
}

