/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;
import java.io.Serializable;

public class LUDecompositionQuick
implements Serializable {
    static final long serialVersionUID = 1020L;
    protected DoubleMatrix2D LU;
    protected int pivsign;
    protected int[] piv;
    protected boolean isNonSingular;
    protected Algebra algebra;
    protected transient double[] workDouble;
    protected transient int[] work1;
    protected transient int[] work2;

    public LUDecompositionQuick() {
        this(Property.DEFAULT.tolerance());
    }

    public LUDecompositionQuick(double d) {
        this.algebra = new Algebra(d);
    }

    public void decompose(DoubleMatrix2D doubleMatrix2D) {
        this.LU = doubleMatrix2D;
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        if (this.piv == null || this.piv.length != n) {
            this.piv = new int[n];
        }
        int n3 = n;
        while (--n3 >= 0) {
            this.piv[n3] = n3;
        }
        this.pivsign = 1;
        if (n * n2 == 0) {
            this.setLU(this.LU);
            return;
        }
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n];
        for (int i = 0; i < n; ++i) {
            doubleMatrix1DArray[i] = this.LU.viewRow(i);
        }
        IntArrayList intArrayList = new IntArrayList();
        DoubleMatrix1D doubleMatrix1D = this.LU.viewColumn(0).like();
        Mult mult = Mult.mult(0.0);
        for (int i = 0; i < n2; ++i) {
            double d;
            double d2;
            int n4;
            doubleMatrix1D.assign(this.LU.viewColumn(i));
            int n5 = n / 10;
            doubleMatrix1D.getNonZeros(intArrayList, null, n5);
            int n6 = intArrayList.size();
            boolean bl = n6 < n5;
            for (n4 = 0; n4 < n; ++n4) {
                int n7 = Math.min(n4, i);
                double d3 = bl ? doubleMatrix1DArray[n4].zDotProduct(doubleMatrix1D, 0, n7, intArrayList) : doubleMatrix1DArray[n4].zDotProduct(doubleMatrix1D, 0, n7);
                d2 = doubleMatrix1D.getQuick(n4);
                double d4 = d2 - d3;
                doubleMatrix1D.setQuick(n4, d4);
                this.LU.setQuick(n4, i, d4);
                if (!bl) continue;
                if (d2 == 0.0 && d4 != 0.0) {
                    int n8 = intArrayList.binarySearch(n4);
                    n8 = -n8 - 1;
                    intArrayList.beforeInsert(n8, n4);
                }
                if (d2 == 0.0 || d4 != 0.0) continue;
                intArrayList.remove(intArrayList.binarySearch(n4));
            }
            n4 = i;
            if (n4 < n) {
                double d5 = Math.abs(doubleMatrix1D.getQuick(n4));
                for (int j = i + 1; j < n; ++j) {
                    d2 = Math.abs(doubleMatrix1D.getQuick(j));
                    if (!(d2 > d5)) continue;
                    n4 = j;
                    d5 = d2;
                }
            }
            if (n4 != i) {
                doubleMatrix1DArray[n4].swap(doubleMatrix1DArray[i]);
                int n9 = this.piv[n4];
                this.piv[n4] = this.piv[i];
                this.piv[i] = n9;
                this.pivsign = -this.pivsign;
            }
            if (i >= n || (d = this.LU.getQuick(i, i)) == 0.0) continue;
            mult.multiplicator = 1.0 / d;
            this.LU.viewColumn(i).viewPart(i + 1, n - (i + 1)).assign(mult);
        }
        this.setLU(this.LU);
    }

    public void decompose(DoubleMatrix2D doubleMatrix2D, int n) {
        if (!this.algebra.property().isSquare(doubleMatrix2D) || n < 0 || n > 2) {
            this.decompose(doubleMatrix2D);
            return;
        }
        this.LU = doubleMatrix2D;
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        if (this.piv == null || this.piv.length != n2) {
            this.piv = new int[n2];
        }
        int n4 = n2;
        while (--n4 >= 0) {
            this.piv[n4] = n4;
        }
        this.pivsign = 1;
        if (n2 * n3 == 0) {
            this.setLU(doubleMatrix2D);
            return;
        }
        if (n == 2) {
            if (n3 > 1) {
                doubleMatrix2D.setQuick(1, 0, doubleMatrix2D.getQuick(1, 0) / doubleMatrix2D.getQuick(0, 0));
            }
            for (n4 = 1; n4 < n3; ++n4) {
                double d = doubleMatrix2D.getQuick(n4, n4) - doubleMatrix2D.getQuick(n4, n4 - 1) * doubleMatrix2D.getQuick(n4 - 1, n4);
                doubleMatrix2D.setQuick(n4, n4, d);
                if (n4 >= n3 - 1) continue;
                doubleMatrix2D.setQuick(n4 + 1, n4, doubleMatrix2D.getQuick(n4 + 1, n4) / d);
            }
        }
        this.setLU(doubleMatrix2D);
    }

    public double det() {
        int n;
        int n2 = this.m();
        if (n2 != (n = this.n())) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        if (!this.isNonsingular()) {
            return 0.0;
        }
        double d = this.pivsign;
        for (int i = 0; i < n; ++i) {
            d *= this.LU.getQuick(i, i);
        }
        return d;
    }

    protected double[] getDoublePivot() {
        int n = this.m();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.piv[i];
        }
        return dArray;
    }

    public DoubleMatrix2D getL() {
        return this.lowerTriangular(this.LU.copy());
    }

    public DoubleMatrix2D getLU() {
        return this.LU.copy();
    }

    public int[] getPivot() {
        return this.piv;
    }

    public DoubleMatrix2D getU() {
        return this.upperTriangular(this.LU.copy());
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    protected boolean isNonsingular(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        double d = this.algebra.property().tolerance();
        int n3 = Math.min(n2, n);
        while (--n3 >= 0) {
            if (!(Math.abs(doubleMatrix2D.getQuick(n3, n3)) <= d)) continue;
            return false;
        }
        return true;
    }

    protected DoubleMatrix2D lowerTriangular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        int n4 = n = Math.min(n2, n3);
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                if (n4 < n5) {
                    doubleMatrix2D.setQuick(n4, n5, 0.0);
                    continue;
                }
                if (n4 != n5) continue;
                doubleMatrix2D.setQuick(n4, n5, 1.0);
            }
        }
        if (n3 > n2) {
            doubleMatrix2D.viewPart(0, n, n2, n3 - n).assign(0.0);
        }
        return doubleMatrix2D;
    }

    protected int m() {
        return this.LU.rows();
    }

    protected int n() {
        return this.LU.columns();
    }

    public void setLU(DoubleMatrix2D doubleMatrix2D) {
        this.LU = doubleMatrix2D;
        this.isNonSingular = this.isNonsingular(doubleMatrix2D);
    }

    public void solve(DoubleMatrix1D doubleMatrix1D) {
        double d;
        int n;
        double d2;
        int n2;
        this.algebra.property().checkRectangular(this.LU);
        int n3 = this.m();
        int n4 = this.n();
        if (doubleMatrix1D.size() != n3) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.workDouble == null || this.workDouble.length < n3) {
            this.workDouble = new double[n3];
        }
        this.algebra.permute(doubleMatrix1D, this.piv, this.workDouble);
        if (n3 * n4 == 0) {
            return;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            d2 = doubleMatrix1D.getQuick(n2);
            if (d2 == 0.0) continue;
            for (n = n2 + 1; n < n4; ++n) {
                d = this.LU.getQuick(n, n2);
                if (d == 0.0) continue;
                doubleMatrix1D.setQuick(n, doubleMatrix1D.getQuick(n) - d2 * d);
            }
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            doubleMatrix1D.setQuick(n2, doubleMatrix1D.getQuick(n2) / this.LU.getQuick(n2, n2));
            d2 = doubleMatrix1D.getQuick(n2);
            if (d2 == 0.0) continue;
            for (n = 0; n < n2; ++n) {
                d = this.LU.getQuick(n, n2);
                if (d == 0.0) continue;
                doubleMatrix1D.setQuick(n, doubleMatrix1D.getQuick(n) - d2 * d);
            }
        }
    }

    public void solve(DoubleMatrix2D doubleMatrix2D) {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4;
        this.algebra.property().checkRectangular(this.LU);
        int n5 = this.m();
        int n6 = this.n();
        if (doubleMatrix2D.rows() != n5) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.work1 == null || this.work1.length < n5) {
            this.work1 = new int[n5];
        }
        this.algebra.permuteRows(doubleMatrix2D, this.piv, this.work1);
        if (n5 * n6 == 0) {
            return;
        }
        int n7 = doubleMatrix2D.columns();
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n6];
        for (int i = 0; i < n6; ++i) {
            doubleMatrix1DArray[i] = doubleMatrix2D.viewRow(i);
        }
        Mult mult = Mult.div(0.0);
        PlusMult plusMult = PlusMult.minusMult(0.0);
        IntArrayList intArrayList = new IntArrayList();
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.make(n7);
        for (n4 = 0; n4 < n6; ++n4) {
            doubleMatrix1D.assign(doubleMatrix1DArray[n4]);
            n3 = n7 / 10;
            doubleMatrix1D.getNonZeros(intArrayList, null, n3);
            n2 = intArrayList.size();
            bl = n2 < n3;
            for (n = n4 + 1; n < n6; ++n) {
                plusMult.multiplicator = -this.LU.getQuick(n, n4);
                if (plusMult.multiplicator == 0.0) continue;
                if (bl) {
                    doubleMatrix1DArray[n].assign(doubleMatrix1D, plusMult, intArrayList);
                    continue;
                }
                doubleMatrix1DArray[n].assign(doubleMatrix1D, plusMult);
            }
        }
        for (n4 = n6 - 1; n4 >= 0; --n4) {
            mult.multiplicator = 1.0 / this.LU.getQuick(n4, n4);
            doubleMatrix1DArray[n4].assign(mult);
            if (doubleMatrix1D == null) {
                doubleMatrix1D = DoubleFactory1D.dense.make(doubleMatrix2D.columns());
            }
            doubleMatrix1D.assign(doubleMatrix1DArray[n4]);
            n3 = n7 / 10;
            doubleMatrix1D.getNonZeros(intArrayList, null, n3);
            n2 = intArrayList.size();
            bl = n2 < n3;
            for (n = 0; n < n4; ++n) {
                plusMult.multiplicator = -this.LU.getQuick(n, n4);
                if (plusMult.multiplicator == 0.0) continue;
                if (bl) {
                    doubleMatrix1DArray[n].assign(doubleMatrix1D, plusMult, intArrayList);
                    continue;
                }
                doubleMatrix1DArray[n].assign(doubleMatrix1D, plusMult);
            }
        }
    }

    private void solveOld(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2;
        this.algebra.property().checkRectangular(this.LU);
        int n3 = this.m();
        int n4 = this.n();
        if (doubleMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        int n5 = doubleMatrix2D.columns();
        if (this.work1 == null || this.work1.length < n3) {
            this.work1 = new int[n3];
        }
        this.algebra.permuteRows(doubleMatrix2D, this.piv, this.work1);
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = n2 + 1; i < n4; ++i) {
                double d = this.LU.getQuick(i, n2);
                if (d == 0.0) continue;
                for (n = 0; n < n5; ++n) {
                    doubleMatrix2D.setQuick(i, n, doubleMatrix2D.getQuick(i, n) - doubleMatrix2D.getQuick(n2, n) * d);
                }
            }
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n6;
            double d = 1.0 / this.LU.getQuick(n2, n2);
            if (d != 1.0) {
                for (n6 = 0; n6 < n5; ++n6) {
                    doubleMatrix2D.setQuick(n2, n6, doubleMatrix2D.getQuick(n2, n6) * d);
                }
            }
            for (n6 = 0; n6 < n2; ++n6) {
                d = this.LU.getQuick(n6, n2);
                if (d == 0.0) continue;
                for (n = 0; n < n5; ++n) {
                    doubleMatrix2D.setQuick(n6, n, doubleMatrix2D.getQuick(n6, n) - doubleMatrix2D.getQuick(n2, n) * d);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("-----------------------------------------------------------------------------\n");
        stringBuffer.append("LUDecompositionQuick(A) --> isNonSingular(A), det(A), pivot, L, U, inverse(A)\n");
        stringBuffer.append("-----------------------------------------------------------------------------\n");
        stringBuffer.append("isNonSingular = ");
        try {
            stringBuffer.append(String.valueOf(this.isNonsingular()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\ndet = ");
        try {
            stringBuffer.append(String.valueOf(this.det()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\npivot = ");
        try {
            stringBuffer.append(String.valueOf(new IntArrayList(this.getPivot())));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nL = ");
        try {
            stringBuffer.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\ninverse(A) = ");
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.identity(this.LU.rows());
        try {
            this.solve(doubleMatrix2D);
            stringBuffer.append(String.valueOf(doubleMatrix2D));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }

    protected DoubleMatrix2D upperTriangular(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2 = doubleMatrix2D.rows();
        int n3 = doubleMatrix2D.columns();
        int n4 = n = Math.min(n2, n3);
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                if (n4 <= n5) continue;
                doubleMatrix2D.setQuick(n4, n5, 0.0);
            }
        }
        if (n3 < n2) {
            doubleMatrix2D.viewPart(n, 0, n2 - n, n3).assign(0.0);
        }
        return doubleMatrix2D;
    }

    private double[] xgetDoublePivot() {
        int n = this.m();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.piv[i];
        }
        return dArray;
    }
}

