/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.render.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.plugins.buildcomparison.render.internal.BuildOutcomeRenderer;
import org.gradle.api.plugins.buildcomparison.render.internal.BuildOutcomeRendererFactory;

public class DefaultBuildOutcomeRendererFactory<C>
implements BuildOutcomeRendererFactory<C> {
    private final Class<C> contextType;
    private final Map<Class<? extends BuildOutcome>, BuildOutcomeRenderer<?, C>> renderers = new HashMap();

    public DefaultBuildOutcomeRendererFactory(Class<C> contextType) {
        this.contextType = contextType;
    }

    public <T extends BuildOutcome> void registerRenderer(BuildOutcomeRenderer<T, C> renderer) {
        if (!renderer.getContextType().isAssignableFrom(this.contextType)) {
            throw new IllegalArgumentException(String.format("Renderer '%s' has context type '%s' which is incompatible with target context type '%s'", renderer, renderer.getContextType(), this.contextType));
        }
        this.renderers.put(renderer.getOutcomeType(), renderer);
    }

    @Override
    public <T extends BuildOutcome> BuildOutcomeRenderer<T, C> getRenderer(Class<? extends T> resultType) {
        return this.renderers.get(resultType);
    }
}

