"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var def = require("raml-definition-system");
var refResolvers = require("./parser/jsyaml/includeRefResolvers");
var schemaGenImpl = require("./parser/tools/schemaModelGen");
var path = require("path");
var contentprovider = require("./util/contentprovider");
var su = def.getSchemaUtils();
function dereference(schemaPath, jsonReference) {
    var project = project.createProject(path.dirname(schemaPath));
    var dummySchema = {
        "$ref": jsonReference
    };
    var schemaContent = JSON.stringify(dummySchema);
    var unit = project.setCachedUnitContent(path.basename(schemaPath), schemaContent);
    var schema = getJSONSchema(schemaContent, unit);
    return schema.jsonSchema["$ref"];
}
exports.dereference = dereference;
function createSchema(c, u) {
    return su.createSchema(c, new contentprovider.ContentProvider(u));
}
exports.createSchema = createSchema;
function getXMLSchema(c) {
    return su.getXMLSchema(c);
}
exports.getXMLSchema = getXMLSchema;
function getJSONSchema(c, u) {
    return su.getJSONSchema(c, new contentprovider.ContentProvider(u));
}
exports.getJSONSchema = getJSONSchema;
function completeReference(includePath, includeReference, content) {
    return refResolvers.completeReference(includePath, includeReference, content);
}
exports.completeReference = completeReference;
function getIncludePath(p) {
    return refResolvers.getIncludePath(p);
}
exports.getIncludePath = getIncludePath;
function getIncludeReference(p) {
    return refResolvers.getIncludeReference(p);
}
exports.getIncludeReference = getIncludeReference;
function createSchemaModelGenerator() {
    return new schemaGenImpl.SchemaToModelGenerator();
}
exports.createSchemaModelGenerator = createSchemaModelGenerator;
function createModelToSchemaGenerator() {
    return new schemaGenImpl.ModelToSchemaGenerator();
}
exports.createModelToSchemaGenerator = createModelToSchemaGenerator;
//# sourceMappingURL=schema.js.map