/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.FingerprintFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.FingerprintAnalyzerProvider;

public class FingerprintTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final char separator;
    private final int maxOutputSize;

    FingerprintTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.separator = FingerprintAnalyzerProvider.parseSeparator((Settings)settings);
        this.maxOutputSize = settings.getAsInt(FingerprintAnalyzerProvider.MAX_OUTPUT_SIZE.getPreferredName(), Integer.valueOf(FingerprintAnalyzerProvider.DEFAULT_MAX_OUTPUT_SIZE));
    }

    public TokenStream create(TokenStream tokenStream) {
        TokenStream result = tokenStream;
        result = new FingerprintFilter(result, this.maxOutputSize, this.separator);
        return result;
    }
}

