/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.job;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.job.DateHistoGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.GroupConfig;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStats;

class IndexerUtils {
    private static final Logger logger = Logger.getLogger((String)IndexerUtils.class.getName());

    IndexerUtils() {
    }

    static List<IndexRequest> processBuckets(CompositeAggregation agg, String rollupIndex, RollupJobStats stats, GroupConfig groupConfig, String jobId) {
        logger.debug((Object)("Buckets: [" + agg.getBuckets().size() + "][" + jobId + "]"));
        return agg.getBuckets().stream().map(b -> {
            stats.incrementNumDocuments(b.getDocCount());
            TreeMap<String, Object> keys = new TreeMap<String, Object>(b.getKey());
            List metrics = b.getAggregations().asList();
            HashMap<String, Object> doc = new HashMap<String, Object>(keys.size() + metrics.size());
            CRC32 docId = IndexerUtils.processKeys(keys, doc, b.getDocCount(), groupConfig);
            byte[] vs = jobId.getBytes(StandardCharsets.UTF_8);
            docId.update(vs, 0, vs.length);
            IndexerUtils.processMetrics(metrics, doc);
            doc.put("_rollup.version", 1);
            doc.put("_rollup." + RollupField.ID.getPreferredName(), jobId);
            IndexRequest request = new IndexRequest(rollupIndex, "_doc", String.valueOf(docId.getValue()));
            request.source(doc);
            return request;
        }).collect(Collectors.toList());
    }

    private static CRC32 processKeys(Map<String, Object> keys, Map<String, Object> doc, long count, GroupConfig groupConfig) {
        CRC32 docID = new CRC32();
        keys.forEach((k, v) -> {
            doc.put(k + "." + "_count", count);
            if (k.endsWith(".date_histogram")) {
                doc.put(k + "." + "timestamp", v);
                doc.put(k + "." + "interval", groupConfig.getDateHisto().getInterval());
                doc.put(k + "." + DateHistoGroupConfig.TIME_ZONE, groupConfig.getDateHisto().getTimeZone().toString());
                docID.update(Numbers.longToBytes((long)((Long)v)), 0, 8);
                return;
            } else if (k.endsWith(".histogram")) {
                doc.put(k + "." + "value", v);
                doc.put(k + "." + "interval", groupConfig.getHisto().getInterval());
                docID.update(Numbers.doubleToBytes((double)((Double)v)), 0, 8);
                return;
            } else {
                if (!k.endsWith(".terms")) throw new ElasticsearchException("Could not identify key in agg [" + k + "]", new Object[0]);
                doc.put(k + "." + "value", v);
                if (v instanceof String) {
                    byte[] vs = ((String)v).getBytes(StandardCharsets.UTF_8);
                    docID.update(vs, 0, vs.length);
                    return;
                } else if (v instanceof Long) {
                    docID.update(Numbers.longToBytes((long)((Long)v)), 0, 8);
                    return;
                } else {
                    if (!(v instanceof Double)) throw new RuntimeException("Encountered value of type [" + v.getClass() + "], which was unable to be processed.");
                    docID.update(Numbers.doubleToBytes((double)((Double)v)), 0, 8);
                }
            }
        });
        return docID;
    }

    private static void processMetrics(List<Aggregation> metrics, Map<String, Object> doc) {
        ArrayList emptyCounts = new ArrayList();
        metrics.forEach(m -> {
            if (m instanceof InternalNumericMetricsAggregation.SingleValue) {
                Double value = ((InternalNumericMetricsAggregation.SingleValue)m).value();
                if (!value.isInfinite()) {
                    if (m.getName().endsWith("_count") && value == 0.0) {
                        emptyCounts.add(m.getName());
                    } else {
                        doc.put(m.getName(), value);
                    }
                }
            } else {
                throw new ElasticsearchException("Aggregation [" + m.getName() + "] is of non-supported type [" + m.getType() + "]", new Object[0]);
            }
        });
        emptyCounts.forEach(m -> doc.remove(m.replace("_count", "value")));
    }
}

