/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.pagerduty;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.actions.pagerduty.PagerDutyAction;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEvent;

public class SentEvent
implements ToXContentObject {
    final IncidentEvent event;
    @Nullable
    final HttpRequest request;
    @Nullable
    final HttpResponse response;
    @Nullable
    final String failureReason;

    public static SentEvent responded(IncidentEvent event, HttpRequest request, HttpResponse response) {
        String failureReason = SentEvent.resolveFailureReason(response);
        return new SentEvent(event, request, response, failureReason);
    }

    public static SentEvent error(IncidentEvent event, String reason) {
        return new SentEvent(event, null, null, reason);
    }

    private SentEvent(IncidentEvent event, HttpRequest request, HttpResponse response, String failureReason) {
        this.event = event;
        this.request = request;
        this.response = response;
        this.failureReason = failureReason;
    }

    public boolean successful() {
        return this.failureReason == null;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentEvent sentEvent = (SentEvent)o;
        return Objects.equals(this.event, sentEvent.event) && Objects.equals(this.request, sentEvent.request) && Objects.equals(this.failureReason, sentEvent.failureReason);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.request, this.response, this.failureReason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(XField.EVENT.getPreferredName(), (ToXContent)this.event, params);
        if (!this.successful()) {
            builder.field(XField.REASON.getPreferredName(), this.failureReason);
            if (this.request != null) {
                if (WatcherParams.hideSecrets((ToXContent.Params)params)) {
                    try (InputStream is = HttpRequest.filterToXContent(this.request, builder.contentType().xContent(), params, "body");){
                        builder.rawField(XField.REQUEST.getPreferredName(), is, builder.contentType());
                    }
                } else {
                    builder.field(XField.REQUEST.getPreferredName());
                    this.request.toXContent(builder, params);
                }
            }
            if (this.response != null) {
                builder.field(XField.RESPONSE.getPreferredName(), (ToXContent)this.response, params);
            }
        }
        return builder.endObject();
    }

    /*
     * Exception decompiling
     */
    private static String resolveFailureReason(HttpResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface XField {
        public static final ParseField EVENT = PagerDutyAction.XField.EVENT;
        public static final ParseField REASON = new ParseField("reason", new String[0]);
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField RESPONSE = new ParseField("response", new String[0]);
        public static final ParseField MESSAGE = new ParseField("message", new String[0]);
        public static final ParseField CODE = new ParseField("code", new String[0]);
        public static final ParseField ERRORS = new ParseField("errors", new String[0]);
    }
}

