/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.monitoring.MonitoringFeatureSetUsage;
import org.elasticsearch.xpack.monitoring.MonitoringService;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;

public class MonitoringFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final MonitoringService monitoring;
    private final XPackLicenseState licenseState;
    private final Exporters exporters;

    @Inject
    public MonitoringFeatureSet(Settings settings, @Nullable MonitoringService monitoring, @Nullable XPackLicenseState licenseState, @Nullable Exporters exporters) {
        this.enabled = (Boolean)XPackSettings.MONITORING_ENABLED.get(settings);
        this.monitoring = monitoring;
        this.licenseState = licenseState;
        this.exporters = exporters;
    }

    public String name() {
        return "monitoring";
    }

    public String description() {
        return "Monitoring for the Elastic Stack";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isMonitoringAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        boolean collectionEnabled = this.monitoring != null && this.monitoring.isMonitoringActive();
        listener.onResponse((Object)new MonitoringFeatureSetUsage(this.available(), this.enabled(), collectionEnabled, MonitoringFeatureSet.exportersUsage(this.exporters)));
    }

    static Map<String, Object> exportersUsage(Exporters exporters) {
        if (exporters == null) {
            return null;
        }
        HashMap<String, Object> usage = new HashMap<String, Object>();
        for (Exporter exporter : exporters) {
            if (!exporter.config().enabled()) continue;
            String type = exporter.config().type();
            int count = (Integer)usage.getOrDefault(type, 0);
            usage.put(type, count + 1);
        }
        return usage;
    }
}

