/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.TermVectorFilteredLeafReader;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class PostingsWithTermVectorsOffsetStrategy
extends FieldOffsetStrategy {
    public PostingsWithTermVectorsOffsetStrategy(String field, BytesRef[] queryTerms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata) {
        super(field, queryTerms, phraseHelper, automata);
    }

    @Override
    public OffsetsEnum getOffsetsEnum(IndexReader reader, int docId, String content) throws IOException {
        Object leafReader;
        if (reader instanceof LeafReader) {
            leafReader = (LeafReader)reader;
        } else {
            List leaves = reader.leaves();
            LeafReaderContext LeafReaderContext2 = (LeafReaderContext)leaves.get(ReaderUtil.subIndex((int)docId, (List)leaves));
            leafReader = LeafReaderContext2.reader();
            docId -= LeafReaderContext2.docBase;
        }
        Terms docTerms = leafReader.getTermVector(docId, this.field);
        if (docTerms == null) {
            return OffsetsEnum.EMPTY;
        }
        leafReader = new TermVectorFilteredLeafReader((LeafReader)leafReader, docTerms);
        return this.createOffsetsEnumFromReader((LeafReader)leafReader, docId);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.POSTINGS_WITH_TERM_VECTORS;
    }
}

