/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.security.action.token.TransportCreateTokenAction;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;

public class TransportRefreshTokenAction
extends HandledTransportAction<CreateTokenRequest, CreateTokenResponse> {
    private final TokenService tokenService;

    @Inject
    public TransportRefreshTokenAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TokenService tokenService) {
        super(settings, "cluster:admin/xpack/security/token/refresh", threadPool, transportService, actionFilters, indexNameExpressionResolver, CreateTokenRequest::new);
        this.tokenService = tokenService;
    }

    protected void doExecute(CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        this.tokenService.refreshToken(request.getRefreshToken(), (ActionListener<Tuple<UserToken, String>>)ActionListener.wrap(tuple -> {
            String tokenStr = this.tokenService.getUserTokenString((UserToken)tuple.v1());
            String scope = TransportCreateTokenAction.getResponseScopeValue(request.getScope());
            CreateTokenResponse response = new CreateTokenResponse(tokenStr, this.tokenService.getExpirationDelay(), scope, (String)tuple.v2());
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

