/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class ExecutorBuilder<U extends ExecutorSettings> {
    private final String name;

    public ExecutorBuilder(String name) {
        this.name = name;
    }

    protected String name() {
        return this.name;
    }

    protected static String settingsKey(String prefix, String key) {
        return String.join((CharSequence)".", prefix, key);
    }

    protected int applyHardSizeLimit(Settings settings, String name) {
        if (name.equals("bulk") || name.equals("index") || name.equals("write")) {
            return 1 + EsExecutors.numberOfProcessors(settings);
        }
        return Integer.MAX_VALUE;
    }

    public abstract List<Setting<?>> getRegisteredSettings();

    abstract U getSettings(Settings var1);

    abstract ThreadPool.ExecutorHolder build(U var1, ThreadContext var2);

    abstract String formatInfo(ThreadPool.Info var1);

    static abstract class ExecutorSettings {
        protected final String nodeName;

        ExecutorSettings(String nodeName) {
            this.nodeName = nodeName;
        }
    }
}

