/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.xpack.sql.type.DataType;

public class EsField {
    private final DataType esDataType;
    private final boolean hasDocValues;
    private final Map<String, EsField> properties;
    private final String name;

    public EsField(String name, DataType esDataType, Map<String, EsField> properties, boolean hasDocValues) {
        this.name = name;
        this.esDataType = esDataType;
        this.hasDocValues = hasDocValues;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.esDataType;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    @Nullable
    public Map<String, EsField> getProperties() {
        return this.properties;
    }

    public EsField getExactField() {
        return this;
    }

    public int getPrecision() {
        return this.esDataType.defaultPrecision;
    }

    public boolean isExact() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsField field = (EsField)o;
        return this.hasDocValues == field.hasDocValues && this.esDataType == field.esDataType && Objects.equals(this.properties, field.properties) && Objects.equals(this.name, field.name);
    }

    public int hashCode() {
        return Objects.hash(this.esDataType, this.hasDocValues, this.properties, this.name);
    }
}

