/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.random;

import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.shape.GeometricShapeBuilder;

public class RandomPointsBuilder
extends GeometricShapeBuilder {
    protected Geometry maskPoly = null;
    private PointOnGeometryLocator extentLocator;

    public RandomPointsBuilder() {
        super(new GeometryFactory());
    }

    public RandomPointsBuilder(GeometryFactory geomFact) {
        super(geomFact);
    }

    public void setExtent(Geometry mask) {
        if (!(mask instanceof Polygonal)) {
            throw new IllegalArgumentException("Only polygonal extents are supported");
        }
        this.maskPoly = mask;
        this.setExtent(mask.getEnvelopeInternal());
        this.extentLocator = new IndexedPointInAreaLocator(mask);
    }

    public Geometry getGeometry() {
        Coordinate[] pts = new Coordinate[this.numPts];
        int i = 0;
        while (i < this.numPts) {
            Coordinate p = this.createRandomCoord(this.getExtent());
            if (this.extentLocator != null && !this.isInExtent(p)) continue;
            pts[i++] = p;
        }
        return this.geomFactory.createMultiPointFromCoords(pts);
    }

    protected boolean isInExtent(Coordinate p) {
        if (this.extentLocator != null) {
            return this.extentLocator.locate(p) != 2;
        }
        return this.getExtent().contains(p);
    }

    protected Coordinate createCoord(double x, double y) {
        Coordinate pt = new Coordinate(x, y);
        this.geomFactory.getPrecisionModel().makePrecise(pt);
        return pt;
    }

    protected Coordinate createRandomCoord(Envelope env) {
        double x = env.getMinX() + env.getWidth() * Math.random();
        double y = env.getMinY() + env.getHeight() * Math.random();
        return this.createCoord(x, y);
    }
}

