/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DeleteRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = 1577020640104649789L;
    private final String dn;

    public DeleteRequestProtocolOp(String dn) {
        this.dn = dn;
    }

    public DeleteRequestProtocolOp(DeleteRequest request) {
        this.dn = request.getDN();
    }

    DeleteRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            this.dn = reader.readString();
            Validator.ensureNotNull(this.dn);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_DELETE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public byte getProtocolOpType() {
        return 74;
    }

    public ASN1Element encodeProtocolOp() {
        return new ASN1OctetString(74, this.dn);
    }

    public static DeleteRequestProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            return new DeleteRequestProtocolOp(ASN1OctetString.decodeAsOctetString(element).stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_DELETE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public void writeTo(ASN1Buffer buffer) {
        buffer.addOctetString((byte)74, this.dn);
    }

    public DeleteRequest toDeleteRequest(Control ... controls) {
        return new DeleteRequest(this.dn, controls);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("DeleteRequestProtocolOp(dn='");
        buffer.append(this.dn);
        buffer.append("')");
    }
}

