/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.UnsupportedEncodingException;

public class OtpErlangString
extends OtpErlangObject {
    private static final long serialVersionUID = -7053595217604929233L;
    private final String str;

    public OtpErlangString(String string) {
        this.str = string;
    }

    public OtpErlangString(OtpErlangList otpErlangList) throws OtpErlangException {
        String string = otpErlangList.stringValue();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.codePointAt(n2);
            if (!OtpErlangString.isValidCodePoint(n3)) {
                throw new OtpErlangRangeException("Invalid CodePoint: " + n3);
            }
            n2 = string.offsetByCodePoints(n2, 1);
        }
        this.str = string;
    }

    public OtpErlangString(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        this.str = otpInputStream.read_string();
    }

    public String stringValue() {
        return this.str;
    }

    @Override
    public String toString() {
        return "\"" + this.str + "\"";
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_string(this.str);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.str.compareTo((String)object) == 0;
        }
        if (object instanceof OtpErlangString) {
            return this.str.compareTo(((OtpErlangString)object).str) == 0;
        }
        return false;
    }

    @Override
    protected int doHashCode() {
        return this.str.hashCode();
    }

    public static int[] stringToCodePoints(String string) {
        int n;
        int n2 = string.codePointCount(0, string.length());
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            nArray[n3++] = n;
        }
        return nArray;
    }

    public static boolean isValidCodePoint(int n) {
        return n >>> 16 <= 16 && (n & 0xFFFFF800) != 55296;
    }

    public static String newString(byte[] byArray) {
        try {
            return new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }
}

