/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.util.EnumMap;
import java.util.Locale;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.DefaultFontConfig;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.render.RendererConfig;
import org.apache.fop.render.ps.PSRendererOption;
import org.apache.fop.render.ps.PSRenderingMode;
import org.apache.fop.util.LogUtil;

public final class PSRendererConfig
implements RendererConfig {
    private final EnumMap<PSRendererOption, Object> params = new EnumMap(PSRendererOption.class);
    private final DefaultFontConfig fontConfig;

    private PSRendererConfig(DefaultFontConfig fontConfig) {
        this.fontConfig = fontConfig;
    }

    @Override
    public DefaultFontConfig getFontInfoConfig() {
        return this.fontConfig;
    }

    public Boolean isAutoRotateLandscape() {
        return (Boolean)this.params.get(PSRendererOption.AUTO_ROTATE_LANDSCAPE);
    }

    public Integer getLanguageLevel() {
        return (Integer)this.params.get(PSRendererOption.LANGUAGE_LEVEL);
    }

    public Boolean isOptimizeResources() {
        return (Boolean)this.params.get(PSRendererOption.OPTIMIZE_RESOURCES);
    }

    public Boolean isSafeSetPageDevice() {
        return (Boolean)this.params.get(PSRendererOption.SAFE_SET_PAGE_DEVICE);
    }

    public Boolean isDscComplianceEnabled() {
        return (Boolean)this.params.get(PSRendererOption.DSC_COMPLIANT);
    }

    public PSRenderingMode getRenderingMode() {
        return (PSRenderingMode)((Object)this.params.get(PSRendererOption.RENDERING_MODE));
    }

    public Boolean isAcrobatDownsample() {
        return (Boolean)this.params.get(PSRendererOption.ACROBAT_DOWNSAMPLE);
    }

    private static final class ParserHelper {
        private PSRendererConfig config;

        private ParserHelper(Configuration cfg, FOUserAgent userAgent) throws ConfigurationException, FOPException {
            this.config = new PSRendererConfig(new DefaultFontConfig.DefaultFontConfigParser().parse(cfg, userAgent.validateStrictly(), new FontEventAdapter(userAgent.getEventBroadcaster())));
            if (cfg != null) {
                this.setBoolConfigParam(cfg, PSRendererOption.AUTO_ROTATE_LANDSCAPE);
                this.setConfigParameter(PSRendererOption.LANGUAGE_LEVEL, cfg.getChild(PSRendererOption.LANGUAGE_LEVEL.getName()).getValueAsInteger(((Integer)PSRendererOption.LANGUAGE_LEVEL.getDefaultValue()).intValue()));
                this.setBoolConfigParam(cfg, PSRendererOption.OPTIMIZE_RESOURCES);
                this.setBoolConfigParam(cfg, PSRendererOption.SAFE_SET_PAGE_DEVICE);
                this.setBoolConfigParam(cfg, PSRendererOption.DSC_COMPLIANT);
                this.setBoolConfigParam(cfg, PSRendererOption.ACROBAT_DOWNSAMPLE);
                Configuration child = cfg.getChild("rendering");
                if (child != null) {
                    this.config.params.put(PSRendererOption.RENDERING_MODE, PSRenderingMode.valueOf(child.getValue(PSRendererOption.RENDERING_MODE.getDefaultValue().toString()).toUpperCase(Locale.ENGLISH)));
                }
            }
        }

        private void setConfigParameter(PSRendererOption option, Object value) {
            this.config.params.put(option, value != null ? value : option.getDefaultValue());
        }

        private void setBoolConfigParam(Configuration cfg, PSRendererOption option) {
            this.setConfigParameter(option, cfg.getChild(option.getName()).getValueAsBoolean(((Boolean)option.getDefaultValue()).booleanValue()));
        }
    }

    public static final class PSRendererConfigParser
    implements RendererConfig.RendererConfigParser {
        private static final Log LOG = LogFactory.getLog(PSRendererConfigParser.class);

        @Override
        public PSRendererConfig build(FOUserAgent userAgent, Configuration cfg) throws FOPException {
            PSRendererConfig config = null;
            try {
                config = new ParserHelper(cfg, userAgent).config;
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, (Exception)((Object)e), false);
            }
            return config;
        }

        @Override
        public String getMimeType() {
            return "application/postscript";
        }
    }
}

