/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.mysqla.io.ProtocolEntityFactory;
import com.mysql.cj.api.mysqla.result.ProtocolEntity;
import com.mysql.cj.api.mysqla.result.Resultset;
import com.mysql.cj.api.mysqla.result.ResultsetRows;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.mysqla.result.MysqlaResultset;
import com.mysql.cj.mysqla.result.OkPacket;

public class ResultsetFactory
implements ProtocolEntityFactory<Resultset> {
    private Resultset.Type type = Resultset.Type.FORWARD_ONLY;
    private Resultset.Concurrency concurrency = Resultset.Concurrency.READ_ONLY;

    public ResultsetFactory(Resultset.Type type, Resultset.Concurrency concurrency) {
        this.type = type;
        this.concurrency = concurrency;
    }

    @Override
    public Resultset.Type getResultSetType() {
        return this.type;
    }

    @Override
    public Resultset.Concurrency getResultSetConcurrency() {
        return this.concurrency;
    }

    @Override
    public Resultset createFromProtocolEntity(ProtocolEntity protocolEntity) {
        if (protocolEntity instanceof OkPacket) {
            return new MysqlaResultset((OkPacket)protocolEntity);
        }
        if (protocolEntity instanceof ResultsetRows) {
            return new MysqlaResultset((ResultsetRows)protocolEntity);
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, "Unknown ProtocolEntity class " + protocolEntity);
    }
}

