/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core.rule.describe;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.UncheckedIOException;
import org.gradle.model.internal.core.rule.describe.AbstractModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class MethodModelRuleDescriptor
extends AbstractModelRuleDescriptor {
    private static final Cache DESCRIPTOR_CACHE = new Cache();
    private static final Joiner PARAM_JOINER = Joiner.on((String)", ");
    private static final Function<ModelType<?>, String> TYPE_DISPLAYNAME_FUNCTION = new Function<ModelType<?>, String>(){

        public String apply(ModelType<?> input) {
            return input.getDisplayName();
        }
    };
    private final WeaklyTypeReferencingMethod<?, ?> method;
    private String description;
    private int hashCode;

    public MethodModelRuleDescriptor(WeaklyTypeReferencingMethod<?, ?> method) {
        this.method = method;
    }

    @Override
    public void describeTo(Appendable appendable) {
        try {
            appendable.append(this.getDescription());
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private String getDescription() {
        if (this.description == null) {
            this.description = this.createDescription();
        }
        return this.description;
    }

    private String createDescription() {
        return this.getClassName() + "#" + this.method.getName() + "(" + MethodModelRuleDescriptor.toParameterList(this.method.getGenericParameterTypes()) + ")";
    }

    private static String toParameterList(List<ModelType<?>> genericParameterTypes) {
        return PARAM_JOINER.join(Iterables.transform(genericParameterTypes, TYPE_DISPLAYNAME_FUNCTION));
    }

    private String getClassName() {
        return this.method.getDeclaringType().getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodModelRuleDescriptor that = (MethodModelRuleDescriptor)o;
        return Objects.equal(this.method, that.method);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result != 0) {
            return result;
        }
        this.hashCode = result = Objects.hashCode((Object[])new Object[]{this.method});
        return result;
    }

    public static <T, R> ModelRuleDescriptor of(WeaklyTypeReferencingMethod<T, R> method) {
        return DESCRIPTOR_CACHE.get(method);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache {
        private final WeakHashMap<Class<?>, CacheEntry> cached = new WeakHashMap();

        private Cache() {
        }

        public synchronized <T, R> ModelRuleDescriptor get(WeaklyTypeReferencingMethod<T, R> method) {
            MethodModelRuleDescriptor methodModelRuleDescriptor;
            Class<T> clazz = method.getDeclaringType().getConcreteClass();
            CacheEntry cacheEntry = this.cached.get(clazz);
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry(clazz);
                this.cached.put(clazz, cacheEntry);
            }
            if ((methodModelRuleDescriptor = cacheEntry.get(method)) == null) {
                methodModelRuleDescriptor = new MethodModelRuleDescriptor(method);
            }
            return methodModelRuleDescriptor;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CacheEntry {
            private final Map<WeaklyTypeReferencingMethod<?, ?>, MethodModelRuleDescriptor> descriptors;

            public CacheEntry(Class<?> clazz) {
                this.descriptors = new HashMap(clazz.getDeclaredMethods().length);
            }

            public <T, R> MethodModelRuleDescriptor get(WeaklyTypeReferencingMethod<T, R> weakMethod) {
                MethodModelRuleDescriptor desc = this.descriptors.get(weakMethod);
                if (desc != null) {
                    return desc;
                }
                desc = new MethodModelRuleDescriptor(weakMethod);
                this.descriptors.put(weakMethod, desc);
                return desc;
            }
        }
    }
}

