/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.AbstractVersionConstraint;
import org.gradle.util.GUtil;

public class DefaultImmutableVersionConstraint
extends AbstractVersionConstraint
implements ImmutableVersionConstraint {
    private static final DefaultImmutableVersionConstraint EMPTY = new DefaultImmutableVersionConstraint("");
    private final String preferredVersion;
    private final ImmutableList<String> rejectedVersions;
    @Nullable
    private final String requiredBranch;
    private final int hashCode;

    public DefaultImmutableVersionConstraint(String preferredVersion, List<String> rejectedVersions) {
        this(preferredVersion, rejectedVersions, null);
    }

    public DefaultImmutableVersionConstraint(String preferredVersion, List<String> rejectedVersions, @Nullable String requiredBranch) {
        if (preferredVersion == null) {
            throw new IllegalArgumentException("Preferred version must not be null");
        }
        if (rejectedVersions == null) {
            throw new IllegalArgumentException("Rejected versions must not be null");
        }
        for (String rejectedVersion : rejectedVersions) {
            if (GUtil.isTrue((Object)rejectedVersion)) continue;
            throw new IllegalArgumentException("Rejected version must not be empty");
        }
        this.preferredVersion = preferredVersion;
        this.rejectedVersions = ImmutableList.copyOf(rejectedVersions);
        this.requiredBranch = requiredBranch;
        this.hashCode = super.hashCode();
    }

    public DefaultImmutableVersionConstraint(String preferredVersion) {
        if (preferredVersion == null) {
            throw new IllegalArgumentException("Preferred version must not be null");
        }
        this.preferredVersion = preferredVersion;
        this.rejectedVersions = ImmutableList.of();
        this.requiredBranch = null;
        this.hashCode = super.hashCode();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Nullable
    public String getBranch() {
        return this.requiredBranch;
    }

    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    public List<String> getRejectedVersions() {
        return this.rejectedVersions;
    }

    public static ImmutableVersionConstraint of(VersionConstraint versionConstraint) {
        if (versionConstraint instanceof ImmutableVersionConstraint) {
            return (ImmutableVersionConstraint)versionConstraint;
        }
        return new DefaultImmutableVersionConstraint(versionConstraint.getPreferredVersion(), versionConstraint.getRejectedVersions());
    }

    public static ImmutableVersionConstraint of(String preferredVersion) {
        if (preferredVersion == null) {
            return DefaultImmutableVersionConstraint.of();
        }
        return new DefaultImmutableVersionConstraint(preferredVersion);
    }

    public static ImmutableVersionConstraint of(String preferredVersion, List<String> rejects) {
        return new DefaultImmutableVersionConstraint(preferredVersion, rejects);
    }

    public static ImmutableVersionConstraint of() {
        return EMPTY;
    }
}

