/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.Describable;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencyResolveDetailsInternal;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.ModuleVersionSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;

public class DefaultDependencyResolveDetails
implements DependencyResolveDetailsInternal {
    private final DependencySubstitutionInternal delegate;
    private ModuleVersionSelector requested;
    private String customDescription;
    private VersionConstraint useVersion;
    private ModuleComponentSelector useSelector;

    public DefaultDependencyResolveDetails(DependencySubstitutionInternal delegate, ModuleVersionSelector requested) {
        this.delegate = delegate;
        this.requested = requested;
    }

    private ComponentSelectionDescriptorInternal selectionReason() {
        ComponentSelectionDescriptorInternal reason = VersionSelectionReasons.SELECTED_BY_RULE;
        if (this.customDescription != null) {
            reason = reason.withReason((Describable)Describables.of((Object)this.customDescription));
        }
        return reason;
    }

    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    public void useVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Configuring the dependency resolve details with 'null' version is not allowed.");
        }
        this.useVersion(new DefaultMutableVersionConstraint(version), this.selectionReason());
    }

    @Override
    public void useVersion(VersionConstraint version, ComponentSelectionDescriptorInternal selectionReason) {
        assert (selectionReason != null);
        if (version == null) {
            throw new IllegalArgumentException("Configuring the dependency resolve details with 'null' version is not allowed.");
        }
        this.useSelector = null;
        this.useVersion = version;
        if (this.delegate.getTarget() instanceof ModuleComponentSelector) {
            ModuleComponentSelector target = (ModuleComponentSelector)this.delegate.getTarget();
            if (!version.equals(target.getVersionConstraint())) {
                this.delegate.useTarget(DefaultModuleComponentSelector.newSelector(target.getModuleIdentifier(), version, target.getAttributes()), selectionReason);
            } else {
                this.delegate.useTarget(this.delegate.getTarget(), selectionReason);
            }
        } else {
            ModuleComponentSelector newTarget = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(this.requested.getGroup(), this.requested.getName()), version);
            this.delegate.useTarget(newTarget, selectionReason);
        }
    }

    public void useTarget(Object notation) {
        ModuleVersionSelector newTarget = (ModuleVersionSelector)ModuleVersionSelectorParsers.parser().parseNotation(notation);
        this.useVersion = null;
        this.useSelector = DefaultModuleComponentSelector.newSelector(newTarget);
        this.useComponentSelector();
    }

    private void useComponentSelector() {
        this.delegate.useTarget(this.useSelector, this.selectionReason());
    }

    @Override
    public ComponentSelectionDescriptorInternal getSelectionDescription() {
        return this.delegate.getSelectionDescription();
    }

    public ModuleVersionSelector getTarget() {
        if (this.delegate.getTarget().equals(this.delegate.getRequested())) {
            return this.requested;
        }
        if (this.delegate.getTarget() instanceof ModuleComponentSelector) {
            return DefaultModuleVersionSelector.newSelector((ModuleComponentSelector)this.delegate.getTarget());
        }
        return this.requested;
    }

    public DependencyResolveDetails because(String description) {
        this.customDescription = description;
        if (this.useVersion != null) {
            this.useVersion(this.useVersion, this.selectionReason());
        } else if (this.useSelector != null) {
            this.useComponentSelector();
        }
        return this;
    }

    @Override
    public boolean isUpdated() {
        return this.delegate.isUpdated();
    }
}

