/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolverDetails;
import org.gradle.internal.Cast;

class ProjectDependencyForcingResolver
implements ModuleConflictResolver {
    private final ModuleConflictResolver delegate;

    ProjectDependencyForcingResolver(ModuleConflictResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T extends ComponentResolutionState> void select(ConflictResolverDetails<T> details) {
        ArrayList<ComponentResolutionState> projectCandidates = null;
        ComponentResolutionState foundProjectCandidate = null;
        for (ComponentResolutionState candidate : details.getCandidates()) {
            if (!(candidate.getComponentId() instanceof ProjectComponentIdentifier)) continue;
            if (foundProjectCandidate == null) {
                foundProjectCandidate = candidate;
                continue;
            }
            if (projectCandidates == null) {
                projectCandidates = new ArrayList<ComponentResolutionState>();
                projectCandidates.add(foundProjectCandidate);
            }
            projectCandidates.add(candidate);
        }
        if (projectCandidates != null) {
            DefaultConflictResolverDetails projectDetails = new DefaultConflictResolverDetails((Collection)Cast.uncheckedCast(projectCandidates));
            this.delegate.select(projectDetails);
            details.select((ComponentResolutionState)projectDetails.getSelected());
            return;
        }
        if (foundProjectCandidate != null) {
            details.select(foundProjectCandidate);
        } else {
            this.delegate.select(details);
        }
    }
}

