/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.local.internal.LocalBuildCacheService;

public class DefaultLocalBuildCacheServiceHandle
implements LocalBuildCacheServiceHandle {
    private final LocalBuildCacheService service;
    private final boolean pushEnabled;

    public DefaultLocalBuildCacheServiceHandle(LocalBuildCacheService service, boolean pushEnabled) {
        this.service = service;
        this.pushEnabled = pushEnabled;
    }

    @Override
    @Nullable
    public LocalBuildCacheService getService() {
        return this.service;
    }

    @Override
    public boolean canLoad() {
        return true;
    }

    @Override
    public void load(BuildCacheKey key, Action<? super File> reader) {
        this.service.loadLocally(key, reader);
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled;
    }

    @Override
    public void store(BuildCacheKey key, File file) {
        this.service.storeLocally(key, file);
    }

    @Override
    public void close() {
        this.service.close();
    }
}

