/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.script;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;
import org.jetbrains.kotlin.script.StandardScriptDefinition;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/common/script/CliScriptDefinitionProvider;", "Lorg/jetbrains/kotlin/script/ScriptDefinitionProvider;", "()V", "definitions", "", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "findScriptDefinition", "fileName", "", "isScript", "", "setScriptDefinitions", "", "newDefinitions", "", "cli"})
public final class CliScriptDefinitionProvider
implements ScriptDefinitionProvider {
    private final List<KotlinScriptDefinition> definitions = CollectionsKt.arrayListOf((Object[])new KotlinScriptDefinition[]{StandardScriptDefinition.INSTANCE});
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        KotlinScriptDefinition kotlinScriptDefinition;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Object v0;
            block4: {
                Iterable $receiver$iv = this.definitions;
                for (Object element$iv : $receiver$iv) {
                    KotlinScriptDefinition it = (KotlinScriptDefinition)element$iv;
                    if (!it.isScript(fileName)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            kotlinScriptDefinition = v0;
        }
        finally {
            readLock.unlock();
        }
        return kotlinScriptDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScript(@NotNull String fileName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2;
            block6: {
                Iterable $receiver$iv = this.definitions;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KotlinScriptDefinition it = (KotlinScriptDefinition)element$iv;
                        if (!it.isScript(fileName)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setScriptDefinitions(@NotNull List<? extends KotlinScriptDefinition> newDefinitions) {
        int n;
        Intrinsics.checkParameterIsNotNull(newDefinitions, (String)"newDefinitions");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.definitions.clear();
            n4 = this.definitions.addAll((Collection<KotlinScriptDefinition>)newDefinitions) ? 1 : 0;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ScriptDefinitionProvider.DefaultImpls.findScriptDefinition(this, file2);
    }
}

