/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.javascript;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.PropertyAccessor;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.javascript.JavaScriptCompileDestinationCalculator;
import org.gradle.play.internal.javascript.JavaScriptCompileSpec;
import org.gradle.plugins.javascript.base.SourceTransformationException;
import org.gradle.util.GFileUtils;

public class GoogleClosureCompiler
implements Compiler<JavaScriptCompileSpec>,
Serializable {
    private static final Iterable<String> SHARED_PACKAGES = Lists.newArrayList((Object[])new String[]{"com.google.javascript"});
    private static final String DEFAULT_GOOGLE_CLOSURE_VERSION = "v20141215";
    private Class<?> sourceFileClass;
    private Class<?> compilerOptionsClass;
    private Class<Enum> compilationLevelClass;
    private Class<Object> compilerClass;

    public Iterable<String> getClassLoaderPackages() {
        return SHARED_PACKAGES;
    }

    public static Object getDependencyNotation() {
        return "com.google.javascript:closure-compiler:v20141215";
    }

    public WorkResult execute(JavaScriptCompileSpec spec) {
        JavaScriptCompileDestinationCalculator destinationCalculator = new JavaScriptCompileDestinationCalculator(spec.getDestinationDir());
        ArrayList allErrors = Lists.newArrayList();
        for (RelativeFile sourceFile : spec.getSources()) {
            allErrors.addAll(this.compile(sourceFile, spec, destinationCalculator));
        }
        if (allErrors.isEmpty()) {
            return WorkResults.didWork((boolean)true);
        }
        throw new SourceTransformationException(String.format("Minification failed with the following errors:\n\t%s", StringUtils.join((Collection)allErrors, (String)"\n\t")), null);
    }

    List<String> compile(RelativeFile javascriptFile, JavaScriptCompileSpec spec, JavaScriptCompileDestinationCalculator destinationCalculator) {
        ArrayList errors = Lists.newArrayList();
        this.loadCompilerClasses(this.getClass().getClassLoader());
        JavaMethod fromCodeJavaMethod = JavaReflectionUtil.staticMethod(this.sourceFileClass, Object.class, (String)"fromCode", (Class[])new Class[]{String.class, String.class});
        Object extern = fromCodeJavaMethod.invokeStatic(new Object[]{"/dev/null", ""});
        JavaMethod fromFileJavaMethod = JavaReflectionUtil.staticMethod(this.sourceFileClass, Object.class, (String)"fromFile", (Class[])new Class[]{File.class});
        Object sourceFile = fromFileJavaMethod.invokeStatic(new Object[]{javascriptFile.getFile()});
        Object compilerOptions = DirectInstantiator.INSTANCE.newInstance(this.compilerOptionsClass, new Object[0]);
        Enum simpleLevel = Enum.valueOf(this.compilationLevelClass, "SIMPLE_OPTIMIZATIONS");
        JavaMethod setOptionsForCompilationLevelMethod = JavaReflectionUtil.method(this.compilationLevelClass, Void.class, (String)"setOptionsForCompilationLevel", (Class[])new Class[]{this.compilerOptionsClass});
        setOptionsForCompilationLevelMethod.invoke((Object)simpleLevel, new Object[]{compilerOptions});
        Object compiler = DirectInstantiator.INSTANCE.newInstance(this.compilerClass, new Object[]{this.getDummyPrintStream()});
        JavaMethod compileMethod = JavaReflectionUtil.method(this.compilerClass, Object.class, (String)"compile", (Class[])new Class[]{this.sourceFileClass, this.sourceFileClass, this.compilerOptionsClass});
        Object result = compileMethod.invoke(compiler, new Object[]{extern, sourceFile, compilerOptions});
        PropertyAccessor jsErrorsField = JavaReflectionUtil.readableField((Object)result, Object[].class, (String)"errors");
        Object[] jsErrors = (Object[])jsErrorsField.getValue(result);
        if (jsErrors.length == 0) {
            JavaMethod toSourceMethod = JavaReflectionUtil.method(this.compilerClass, String.class, (String)"toSource", (Class[])new Class[0]);
            String compiledSource = (String)toSourceMethod.invoke(compiler, new Object[0]);
            GFileUtils.writeFile((String)compiledSource, (File)destinationCalculator.transform(javascriptFile));
        } else {
            for (Object error : jsErrors) {
                errors.add(error.toString());
            }
        }
        return errors;
    }

    private void loadCompilerClasses(ClassLoader cl) {
        try {
            Class<?> clazz;
            if (this.sourceFileClass == null) {
                this.sourceFileClass = cl.loadClass("com.google.javascript.jscomp.SourceFile");
            }
            if (this.compilerOptionsClass == null) {
                this.compilerOptionsClass = cl.loadClass("com.google.javascript.jscomp.CompilerOptions");
            }
            if (this.compilationLevelClass == null) {
                clazz = cl.loadClass("com.google.javascript.jscomp.CompilationLevel");
                this.compilationLevelClass = clazz;
            }
            if (this.compilerClass == null) {
                clazz = cl.loadClass("com.google.javascript.jscomp.Compiler");
                this.compilerClass = clazz;
            }
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private PrintStream getDummyPrintStream() {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        return new PrintStream(os);
    }
}

