/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.PropertyInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLockableProperty<T>
extends AbstractProvider<T>
implements PropertyInternal<T> {
    private PropertyInternal<T> delegate;
    private boolean locked;
    private T value;
    private Class<T> type;
    private String realizedToString;

    public AbstractLockableProperty(PropertyInternal<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setFromAnyValue(Object object) {
        this.assertNotLocked();
        this.delegate.setFromAnyValue(object);
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.locked ? this.type : this.delegate.getType();
    }

    @Nullable
    public T getOrNull() {
        return (T)(this.locked ? this.value : this.delegate.getOrNull());
    }

    public void lockNow() {
        this.locked = true;
        Object currentValue = this.delegate.getOrNull();
        this.value = currentValue == null ? null : this.immutableCopy(currentValue);
        this.type = this.delegate.getType();
        this.realizedToString = this.delegate.toString();
        this.delegate = null;
    }

    protected abstract T immutableCopy(T var1);

    protected void assertNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("This property is locked and cannot be changed.");
        }
    }

    @Override
    public String toString() {
        if (this.locked) {
            return String.format("locked(%s, %s)", this.realizedToString, this.value);
        }
        return String.format("unlocked(%s)", this.delegate);
    }
}

