/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.LoadProjectsBuildOperationType;
import org.gradle.initialization.NotifyProjectsLoadedBuildOperationType;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingBuildLoader
implements BuildLoader {
    private static final NotifyProjectsLoadedBuildOperationType.Result PROJECTS_LOADED_OP_RESULT = new NotifyProjectsLoadedBuildOperationType.Result(){};
    private final BuildLoader buildLoader;
    private final BuildOperationExecutor buildOperationExecutor;
    private static final Comparator<LoadProjectsBuildOperationType.Result.Project> PROJECT_COMPARATOR = new Comparator<LoadProjectsBuildOperationType.Result.Project>(){

        @Override
        public int compare(LoadProjectsBuildOperationType.Result.Project o1, LoadProjectsBuildOperationType.Result.Project o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public NotifyingBuildLoader(BuildLoader buildLoader, BuildOperationExecutor buildOperationExecutor) {
        this.buildLoader = buildLoader;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(final SettingsInternal settings, final GradleInternal gradle) {
        final String buildPath = gradle.getIdentityPath().toString();
        try {
            this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Void>(){

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Load projects").progressDisplayName("Loading projects").details((Object)new LoadProjectsBuildOperationType.Details(){

                        public String getBuildPath() {
                            return buildPath;
                        }
                    });
                }

                public Void call(BuildOperationContext context) {
                    NotifyingBuildLoader.this.buildLoader.load(settings, gradle);
                    context.setResult((Object)NotifyingBuildLoader.this.createOperationResult(gradle, buildPath));
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            this.buildOperationExecutor.run(new RunnableBuildOperation(gradle, buildPath){
                final /* synthetic */ GradleInternal val$gradle;
                final /* synthetic */ String val$buildPath;
                {
                    this.val$gradle = gradleInternal;
                    this.val$buildPath = string;
                }

                public void run(BuildOperationContext context) {
                    this.val$gradle.getBuildListenerBroadcaster().projectsLoaded((Gradle)this.val$gradle);
                    context.setResult((Object)PROJECTS_LOADED_OP_RESULT);
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)this.val$gradle.contextualize("Notify projectsLoaded listeners")).details((Object)new NotifyProjectsLoadedBuildOperationType.Details(){

                        public String getBuildPath() {
                            return val$buildPath;
                        }
                    });
                }
            });
            throw throwable;
        }
        this.buildOperationExecutor.run(new /* invalid duplicate definition of identical inner class */);
    }

    private BuildStructureOperationResult createOperationResult(GradleInternal gradle, String buildPath) {
        LoadProjectsBuildOperationType.Result.Project rootProject = this.convert(gradle.getRootProject());
        return new BuildStructureOperationResult(rootProject, buildPath);
    }

    private LoadProjectsBuildOperationType.Result.Project convert(Project project) {
        return new BuildStructureOperationProject(project.getName(), project.getPath(), ((ProjectInternal)project).getIdentityPath().toString(), project.getProjectDir().getAbsolutePath(), project.getBuildFile().getAbsolutePath(), this.convert(project.getChildProjects().values()));
    }

    private Set<LoadProjectsBuildOperationType.Result.Project> convert(Iterable<Project> children) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PROJECT_COMPARATOR);
        for (Project child : children) {
            builder.add((Object)this.convert(child));
        }
        return builder.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildStructureOperationProject
    implements LoadProjectsBuildOperationType.Result.Project {
        private final String name;
        private final String path;
        private final String identityPath;
        private final String projectDir;
        private final String buildFile;
        private final Set<LoadProjectsBuildOperationType.Result.Project> children;

        public BuildStructureOperationProject(String name, String path, String identityPath, String projectDir, String buildFile, Set<LoadProjectsBuildOperationType.Result.Project> children) {
            this.name = name;
            this.path = path;
            this.identityPath = identityPath;
            this.projectDir = projectDir;
            this.buildFile = buildFile;
            this.children = children;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getIdentityPath() {
            return this.identityPath;
        }

        @Override
        public String getProjectDir() {
            return this.projectDir;
        }

        @Override
        public String getBuildFile() {
            return this.buildFile;
        }

        @Override
        public Set<LoadProjectsBuildOperationType.Result.Project> getChildren() {
            return this.children;
        }
    }

    private static class BuildStructureOperationResult
    implements LoadProjectsBuildOperationType.Result {
        private final LoadProjectsBuildOperationType.Result.Project rootProject;
        private final String buildPath;

        public BuildStructureOperationResult(LoadProjectsBuildOperationType.Result.Project rootProject, String buildPath) {
            this.rootProject = rootProject;
            this.buildPath = buildPath;
        }

        public LoadProjectsBuildOperationType.Result.Project getRootProject() {
            return this.rootProject;
        }

        public String getBuildPath() {
            return this.buildPath;
        }
    }
}

