/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;

public class RenderableUnresolvedDependencyResult
extends AbstractRenderableDependency {
    private final UnresolvedDependencyResult dependency;

    public RenderableUnresolvedDependencyResult(UnresolvedDependencyResult dependency) {
        this.dependency = dependency;
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return RenderableDependency.ResolutionState.FAILED;
    }

    @Override
    public Object getId() {
        return this.dependency.getAttempted();
    }

    @Override
    public String getName() {
        ComponentSelector attempted;
        ComponentSelector requested = this.dependency.getRequested();
        if (requested.equals(attempted = this.dependency.getAttempted())) {
            return requested.getDisplayName();
        }
        if (requested instanceof ModuleComponentSelector && attempted instanceof ModuleComponentSelector) {
            ModuleComponentSelector requestedSelector = (ModuleComponentSelector)requested;
            ModuleComponentSelector attemptedSelector = (ModuleComponentSelector)attempted;
            if (requestedSelector.getGroup().equals(attemptedSelector.getGroup()) && requestedSelector.getModule().equals(attemptedSelector.getModule()) && !requestedSelector.getVersionConstraint().equals(attemptedSelector.getVersionConstraint())) {
                return requested.getDisplayName() + " -> " + ((ModuleComponentSelector)attempted).getVersionConstraint().getPreferredVersion();
            }
        }
        return requested.getDisplayName() + " -> " + attempted.getDisplayName();
    }
}

