/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.server.Group;
import com.sparshui.server.ServerToClientProtocol;
import com.sparshui.server.TouchPoint;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;

class ClientConnection {
    private ServerToClientProtocol _protocol;
    private Map<Integer, Group> _groups;

    ClientConnection(Socket socket) throws IOException {
        this._protocol = new ServerToClientProtocol(socket);
        this._groups = new Hashtable<Integer, Group>();
    }

    boolean processBirth(TouchPoint touchPoint) throws IOException {
        Group group;
        int groupID = touchPoint == null ? 0x10000000 : this.getGroupID(touchPoint);
        int jmolFlags = groupID & 0xF0000000;
        if (jmolFlags != 0) {
            switch (jmolFlags) {
                case 0x10000000: {
                    this._groups = new Hashtable<Integer, Group>();
                }
            }
            groupID &= ~jmolFlags;
        }
        if ((group = this.getGroup(groupID)) != null) {
            touchPoint.setGroup(group);
            return true;
        }
        return false;
    }

    private Lst<GestureType> getGestures(int groupID) throws IOException {
        return this._protocol.getGestures(groupID);
    }

    private int getGroupID(TouchPoint touchPoint) throws IOException {
        return this._protocol.getGroupID(touchPoint);
    }

    private Group getGroup(int groupID) throws IOException {
        if (groupID == 0) {
            return null;
        }
        Group group = null;
        Integer gid = groupID;
        if (this._groups.containsKey(gid)) {
            group = this._groups.get(gid);
        } else {
            Lst<GestureType> gestureTypes = this.getGestures(groupID);
            group = new Group(groupID, gestureTypes, this._protocol);
            this._groups.put(gid, group);
        }
        return group;
    }

    public void processError(int errCode) {
        try {
            this._protocol.processError(errCode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

