/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class RemoteControlHttpsServer
extends Thread {
    private final ServerSocket server;
    private static volatile RemoteControlHttpsServer instance4;
    private static volatile RemoteControlHttpsServer instance6;
    private SSLContext sslContext;
    private static final int HTTPS_PORT = 8112;
    public static final String KEYSTORE_FILENAME = "josm.keystore";
    public static final StringProperty KEYSTORE_PASSWORD;
    public static final StringProperty KEYENTRY_PASSWORD;
    public static final String ENTRY_ALIAS = "josm_localhost";

    private static GeneralNameInterface createGeneralNameInterface(String t, String v) throws IOException {
        switch (t.toLowerCase(Locale.ENGLISH)) {
            case "uri": {
                return new URIName(v);
            }
            case "dns": {
                return new DNSName(v);
            }
            case "ip": {
                return new IPAddressName(v);
            }
        }
        return new OIDName(v);
    }

    private static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm, String san) throws GeneralSecurityException, IOException {
        X509CertInfo info = new X509CertInfo();
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        CertificateValidity interval = new CertificateValidity(from, to);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        X500Name owner = new X500Name(dn);
        info.set("validity", interval);
        info.set("serialNumber", new CertificateSerialNumber(sn));
        info.set("subject", owner);
        info.set("issuer", owner);
        info.set("key", new CertificateX509Key(pair.getPublic()));
        info.set("version", new CertificateVersion(2));
        AlgorithmId algo = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
        info.set("algorithmID", new CertificateAlgorithmId(algo));
        CertificateExtensions ext = new CertificateExtensions();
        ext.set("BasicConstraints", new BasicConstraintsExtension(Boolean.TRUE, false, 0));
        ext.set("ExtendedKeyUsage", new ExtendedKeyUsageExtension(Boolean.TRUE, new Vector<ObjectIdentifier>(Arrays.asList(new ObjectIdentifier("1.3.6.1.5.5.7.3.1")))));
        if (san != null) {
            String[] ps = san.split(",");
            GeneralNames gnames = new GeneralNames();
            for (String item : ps) {
                int colonpos = item.indexOf(58);
                if (colonpos < 0) {
                    throw new IllegalArgumentException("Illegal item " + item + " in " + san);
                }
                String t = item.substring(0, colonpos);
                String v = item.substring(colonpos + 1);
                gnames.add(new GeneralName(RemoteControlHttpsServer.createGeneralNameInterface(t, v)));
            }
            ext.set("SubjectAlternativeName", new SubjectAlternativeNameExtension(Boolean.FALSE, gnames));
        }
        info.set("extensions", ext);
        PrivateKey privkey = pair.getPrivate();
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm);
        algo = (AlgorithmId)cert.get("x509.algorithm");
        info.set("algorithmID.algorithm", algo);
        cert = new X509CertImpl(info);
        cert.sign(privkey, algorithm);
        return cert;
    }

    public static Path setupJosmKeystore() throws IOException, GeneralSecurityException {
        Path dir = Paths.get(RemoteControl.getRemoteControlDir(), new String[0]);
        Path path = dir.resolve(KEYSTORE_FILENAME);
        Files.createDirectories(dir, new FileAttribute[0]);
        if (!path.toFile().exists()) {
            Logging.debug("No keystore found, creating a new one");
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            KeyPair pair = generator.generateKeyPair();
            X509Certificate cert = RemoteControlHttpsServer.generateCertificate("CN=localhost, OU=JOSM, O=OpenStreetMap", pair, 1825, "SHA256withRSA", "dns:localhost,ip:127.0.0.1,ip:::1,uri:https://127.0.0.1:8112,uri:https://::1:8112");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null, null);
            SecureRandom random = new SecureRandom();
            KEYSTORE_PASSWORD.put(new BigInteger(130, random).toString(32));
            KEYENTRY_PASSWORD.put(new BigInteger(130, random).toString(32));
            char[] storePassword = KEYSTORE_PASSWORD.get().toCharArray();
            char[] entryPassword = KEYENTRY_PASSWORD.get().toCharArray();
            ks.setKeyEntry(ENTRY_ALIAS, pair.getPrivate(), entryPassword, new Certificate[]{cert});
            try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE);){
                ks.store(out, storePassword);
            }
        }
        return path;
    }

    public static KeyStore loadJosmKeystore() throws IOException, GeneralSecurityException {
        try (InputStream in = Files.newInputStream(RemoteControlHttpsServer.setupJosmKeystore(), new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(in, KEYSTORE_PASSWORD.get().toCharArray());
            if (Logging.isDebugEnabled()) {
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    Logging.debug("Alias in JOSM keystore: {0}", aliases.nextElement());
                }
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    private void initialize() throws IOException, GeneralSecurityException {
        KeyStore ks = RemoteControlHttpsServer.loadJosmKeystore();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, KEYENTRY_PASSWORD.get().toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ks);
        this.sslContext = SSLContext.getInstance("TLSv1.2");
        this.sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        if (Logging.isTraceEnabled()) {
            Logging.trace("SSL Context protocol: {0}", this.sslContext.getProtocol());
            Logging.trace("SSL Context provider: {0}", this.sslContext.getProvider());
        }
        RemoteControlHttpsServer.setupPlatform(ks);
    }

    public static boolean setupPlatform(KeyStore josmKs) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Enumeration<String> aliases = josmKs.aliases();
        if (aliases.hasMoreElements()) {
            return Main.platform.setupHttpsCertificate(ENTRY_ALIAS, new KeyStore.TrustedCertificateEntry(josmKs.getCertificate(aliases.nextElement())));
        }
        return false;
    }

    public static void restartRemoteControlHttpsServer() {
        block5: {
            RemoteControlHttpsServer.stopRemoteControlHttpsServer();
            if (RemoteControl.PROP_REMOTECONTROL_HTTPS_ENABLED.get().booleanValue()) {
                int port = Config.getPref().getInt("remote.control.https.port", 8112);
                try {
                    instance4 = new RemoteControlHttpsServer(port, false);
                    instance4.start();
                }
                catch (IOException | GeneralSecurityException ex) {
                    Logging.debug(ex);
                    Logging.warn(I18n.marktr("Cannot start IPv4 remotecontrol https server on port {0}: {1}"), Integer.toString(port), ex.getLocalizedMessage());
                }
                try {
                    instance6 = new RemoteControlHttpsServer(port, true);
                    instance6.start();
                }
                catch (IOException | GeneralSecurityException ex) {
                    if (instance4 != null) break block5;
                    Logging.debug(ex);
                    Logging.warn(I18n.marktr("Cannot start IPv6 remotecontrol https server on port {0}: {1}"), Integer.toString(port), ex.getLocalizedMessage());
                }
            }
        }
    }

    public static void stopRemoteControlHttpsServer() {
        if (instance4 != null) {
            try {
                instance4.stopServer();
            }
            catch (IOException ioe) {
                Logging.error(ioe);
            }
            instance4 = null;
        }
        if (instance6 != null) {
            try {
                instance6.stopServer();
            }
            catch (IOException ioe) {
                Logging.error(ioe);
            }
            instance6 = null;
        }
    }

    public RemoteControlHttpsServer(int port, boolean ipv6) throws IOException, GeneralSecurityException {
        super("RemoteControl HTTPS Server");
        this.setDaemon(true);
        this.initialize();
        SSLServerSocketFactory factory = this.sslContext.getServerSocketFactory();
        if (Logging.isTraceEnabled()) {
            Logging.trace("SSL factory - Supported Cipher suites: {0}", Arrays.toString(factory.getSupportedCipherSuites()));
        }
        this.server = factory.createServerSocket(port, 1, ipv6 ? RemoteControl.getInet6Address() : RemoteControl.getInet4Address());
        if (Logging.isTraceEnabled() && this.server instanceof SSLServerSocket) {
            SSLServerSocket sslServer = (SSLServerSocket)this.server;
            Logging.trace("SSL server - Enabled Cipher suites: {0}", Arrays.toString(sslServer.getEnabledCipherSuites()));
            Logging.trace("SSL server - Enabled Protocols: {0}", Arrays.toString(sslServer.getEnabledProtocols()));
            Logging.trace("SSL server - Enable Session Creation: {0}", sslServer.getEnableSessionCreation());
            Logging.trace("SSL server - Need Client Auth: {0}", sslServer.getNeedClientAuth());
            Logging.trace("SSL server - Want Client Auth: {0}", sslServer.getWantClientAuth());
            Logging.trace("SSL server - Use Client Mode: {0}", sslServer.getUseClientMode());
        }
    }

    @Override
    public void run() {
        Logging.info(I18n.marktr("RemoteControl::Accepting secure remote connections on {0}:{1}"), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        while (true) {
            try {
                while (true) {
                    Socket request = this.server.accept();
                    if (Logging.isTraceEnabled() && request instanceof SSLSocket) {
                        SSLSocket sslSocket = (SSLSocket)request;
                        Logging.trace("SSL socket - Enabled Cipher suites: {0}", Arrays.toString(sslSocket.getEnabledCipherSuites()));
                        Logging.trace("SSL socket - Enabled Protocols: {0}", Arrays.toString(sslSocket.getEnabledProtocols()));
                        Logging.trace("SSL socket - Enable Session Creation: {0}", sslSocket.getEnableSessionCreation());
                        Logging.trace("SSL socket - Need Client Auth: {0}", sslSocket.getNeedClientAuth());
                        Logging.trace("SSL socket - Want Client Auth: {0}", sslSocket.getWantClientAuth());
                        Logging.trace("SSL socket - Use Client Mode: {0}", sslSocket.getUseClientMode());
                        Logging.trace("SSL socket - Session: {0}", sslSocket.getSession());
                    }
                    RequestProcessor.processRequest(request);
                }
            }
            catch (SocketException e) {
                if (this.server.isClosed()) continue;
                Logging.error(e);
                continue;
            }
            catch (IOException ioe) {
                Logging.error(ioe);
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        Logging.info(I18n.marktr("RemoteControl::Server {0}:{1} stopped."), this.server.getInetAddress(), Integer.toString(this.server.getLocalPort()));
        this.server.close();
    }

    static {
        KEYSTORE_PASSWORD = new StringProperty("remotecontrol.https.keystore.password", "");
        KEYENTRY_PASSWORD = new StringProperty("remotecontrol.https.keyentry.password", "");
    }
}

