/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

public class MockJspWriter
extends JspWriter {
    private PrintWriter printWriter;
    private Writer writer;
    private HttpServletResponse response;
    private boolean providedWriter;

    public MockJspWriter() {
        super(0, true);
        this.writer = new StringWriter();
        this.printWriter = new PrintWriter(this.writer);
        this.response = null;
        this.providedWriter = false;
    }

    public MockJspWriter(HttpServletResponse httpServletResponse) throws IOException {
        super(0, true);
        this.writer = httpServletResponse.getWriter();
        this.response = httpServletResponse;
        this.printWriter = new PrintWriter(this.writer);
        this.providedWriter = false;
    }

    public MockJspWriter(Writer writer) {
        super(0, true);
        this.writer = writer;
        this.printWriter = new PrintWriter(writer);
        this.response = null;
        this.providedWriter = true;
    }

    public String getOutputAsString() {
        try {
            this.flush();
            if (!this.providedWriter) {
                if (null == this.response) {
                    return ((StringWriter)this.writer).toString();
                }
                if (this.response instanceof MockHttpServletResponse) {
                    return ((MockHttpServletResponse)this.response).getOutputStreamContent();
                }
            }
            return "";
        }
        catch (IOException iOException) {
            throw new NestedApplicationException(iOException);
        }
    }

    public String toString() {
        return this.getOutputAsString();
    }

    public void clear() throws IOException {
        if (this.providedWriter) {
            throw new IOException("Illegal call if writer is provided.");
        }
        this.clearWriter();
    }

    public void clearBuffer() throws IOException {
        if (!this.providedWriter) {
            this.clearWriter();
        }
    }

    private void clearWriter() throws IOException {
        if (null == this.response) {
            this.writer = new StringWriter();
            this.printWriter = new PrintWriter(this.writer);
        } else {
            this.flush();
            this.response.resetBuffer();
        }
    }

    public void close() throws IOException {
        this.flush();
        this.printWriter.close();
    }

    public int getRemaining() {
        return 0;
    }

    public void flush() throws IOException {
        this.printWriter.flush();
    }

    public void newLine() throws IOException {
        this.print(System.getProperty("line.separator"));
    }

    public void print(boolean bl) throws IOException {
        this.printWriter.print(bl);
    }

    public void print(char c) throws IOException {
        this.printWriter.print(c);
    }

    public void print(char[] cArray) throws IOException {
        this.printWriter.print(cArray);
    }

    public void print(double d) throws IOException {
        this.printWriter.print(d);
    }

    public void print(float f) throws IOException {
        this.printWriter.print(f);
    }

    public void print(int n) throws IOException {
        this.printWriter.print(n);
    }

    public void print(long l) throws IOException {
        this.printWriter.print(l);
    }

    public void print(Object object) throws IOException {
        this.printWriter.print(object);
    }

    public void print(String string) throws IOException {
        this.printWriter.print(string);
    }

    public void println() throws IOException {
        this.printWriter.println();
    }

    public void println(boolean bl) throws IOException {
        this.printWriter.println(bl);
    }

    public void println(char c) throws IOException {
        this.printWriter.println(c);
    }

    public void println(char[] cArray) throws IOException {
        this.printWriter.println(cArray);
    }

    public void println(double d) throws IOException {
        this.printWriter.println(d);
    }

    public void println(float f) throws IOException {
        this.printWriter.println(f);
    }

    public void println(int n) throws IOException {
        this.printWriter.println(n);
    }

    public void println(long l) throws IOException {
        this.printWriter.println(l);
    }

    public void println(Object object) throws IOException {
        this.printWriter.println(object);
    }

    public void println(String string) throws IOException {
        this.printWriter.println(string);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.printWriter.write(cArray, n, n2);
    }
}

