/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.BuildDifference;
import org.jetbrains.kotlin.incremental.BuildDiffsStorage;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage;", "", "buildDiffs", "", "Lorg/jetbrains/kotlin/incremental/BuildDifference;", "(Ljava/util/List;)V", "getBuildDiffs", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "incremental-compilation-impl"})
public final class BuildDiffsStorage {
    @NotNull
    private final List<BuildDifference> buildDiffs;
    private static final int MAX_DIFFS_ENTRIES = 10;
    private static int CURRENT_VERSION;
    public static final Companion Companion;

    @NotNull
    public final List<BuildDifference> getBuildDiffs() {
        return this.buildDiffs;
    }

    public BuildDiffsStorage(@NotNull List<BuildDifference> buildDiffs) {
        Intrinsics.checkParameterIsNotNull(buildDiffs, "buildDiffs");
        this.buildDiffs = buildDiffs;
    }

    static {
        Companion = new Companion(null);
        MAX_DIFFS_ENTRIES = 10;
    }

    @NotNull
    public final List<BuildDifference> component1() {
        return this.buildDiffs;
    }

    @NotNull
    public final BuildDiffsStorage copy(@NotNull List<BuildDifference> buildDiffs) {
        Intrinsics.checkParameterIsNotNull(buildDiffs, "buildDiffs");
        return new BuildDiffsStorage(buildDiffs);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BuildDiffsStorage copy$default(BuildDiffsStorage buildDiffsStorage, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = buildDiffsStorage.buildDiffs;
        }
        return buildDiffsStorage.copy(list2);
    }

    public String toString() {
        return "BuildDiffsStorage(buildDiffs=" + this.buildDiffs + ")";
    }

    public int hashCode() {
        List<BuildDifference> list2 = this.buildDiffs;
        return list2 != null ? ((Object)list2).hashCode() : 0;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BuildDiffsStorage)) break block3;
                BuildDiffsStorage buildDiffsStorage = (BuildDiffsStorage)object;
                if (!Intrinsics.areEqual(this.buildDiffs, buildDiffsStorage.buildDiffs)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\f\u0010\u0017\u001a\u00020\r*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0018H\u0002J\u0014\u0010\u001b\u001a\u00020\u0015*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0014\u0010\u001e\u001a\u00020\u0015*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage$Companion;", "", "()V", "CURRENT_VERSION", "", "getCURRENT_VERSION", "()I", "setCURRENT_VERSION", "(I)V", "MAX_DIFFS_ENTRIES", "getMAX_DIFFS_ENTRIES$incremental_compilation_impl", "readDiffsFromFile", "", "Lorg/jetbrains/kotlin/incremental/BuildDifference;", "file", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "readFromFile", "Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage;", "writeToFile", "", "storage", "readBuildDifference", "Ljava/io/ObjectInputStream;", "readDirtyData", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "writeBuildDifference", "Ljava/io/ObjectOutputStream;", "diff", "writeDirtyData", "dirtyData", "incremental-compilation-impl"})
    public static final class Companion {
        @Nullable
        public final BuildDiffsStorage readFromFile(@NotNull File file2, @Nullable ICReporter reporter) {
            BuildDiffsStorage buildDiffsStorage;
            List<BuildDifference> diffs;
            Intrinsics.checkParameterIsNotNull(file2, "file");
            List<BuildDifference> list2 = diffs = this.readDiffsFromFile(file2, reporter);
            if (list2 != null) {
                List<BuildDifference> list3;
                List<BuildDifference> it = list3 = list2;
                buildDiffsStorage = new BuildDiffsStorage(it);
            } else {
                buildDiffsStorage = null;
            }
            return buildDiffsStorage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final List<BuildDifference> readDiffsFromFile(@NotNull File file2, @Nullable ICReporter reporter) {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            Function1<String, Unit> reportFail$ = new Function1<String, Unit>(reporter, file2){
                final /* synthetic */ ICReporter $reporter;
                final /* synthetic */ File $file;

                public final void invoke(@NotNull String reason) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull(reason, "reason");
                        ICReporter iCReporter = this.$reporter;
                        if (iCReporter == null) break block0;
                        iCReporter.report(new Function0<String>(this, reason){
                            final /* synthetic */ readDiffsFromFile.1 this$0;
                            final /* synthetic */ String $reason;

                            @NotNull
                            public final String invoke() {
                                return "Could not read diff from file " + this.this$0.$file + ": " + this.$reason;
                            }
                            {
                                this.this$0 = var1_1;
                                this.$reason = string;
                                super(0);
                            }
                        });
                    }
                }
                {
                    this.$reporter = iCReporter;
                    this.$file = file2;
                    super(1);
                }
            };
            if (!file2.exists()) {
                return null;
            }
            try {
                Object object = file2;
                InputStream inputStream = new FileInputStream((File)object);
                object = inputStream;
                int n = 8192;
                inputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                InputStream inputStream2 = inputStream;
                object = new ObjectInputStream(inputStream2);
                Throwable throwable = null;
                try {
                    ObjectInputStream input = (ObjectInputStream)object;
                    int version = input.readInt();
                    if (version != Companion.getCURRENT_VERSION()) {
                        reportFail$.invoke("incompatible version " + version + ", actual version is " + Companion.getCURRENT_VERSION());
                        List<BuildDifference> list2 = null;
                        return list2;
                    }
                    int size = input.readInt();
                    ArrayList<BuildDifference> result2 = new ArrayList<BuildDifference>(size);
                    int n2 = 0;
                    int n3 = size;
                    while (n2 < n3) {
                        int it = n2++;
                        result2.add(Companion.readBuildDifference(input));
                    }
                    List list3 = result2;
                    return list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                }
            }
            catch (IOException e) {
                reportFail$.invoke(e.toString());
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeToFile(@NotNull File file2, @NotNull BuildDiffsStorage storage2, @Nullable ICReporter reporter) {
            block8: {
                Intrinsics.checkParameterIsNotNull(file2, "file");
                Intrinsics.checkParameterIsNotNull(storage2, "storage");
                file2.getParentFile().mkdirs();
                try {
                    Object object = file2;
                    OutputStream outputStream2 = new FileOutputStream((File)object);
                    object = outputStream2;
                    int n = 8192;
                    outputStream2 = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
                    OutputStream outputStream3 = outputStream2;
                    object = new ObjectOutputStream(outputStream3);
                    Throwable throwable = null;
                    try {
                        ObjectOutputStream output = (ObjectOutputStream)object;
                        output.writeInt(Companion.getCURRENT_VERSION());
                        Iterable $receiver$iv = storage2.getBuildDiffs();
                        Iterable iterable = $receiver$iv;
                        Comparator comparator = new Comparator<T>(){

                            public final int compare(T a, T b) {
                                BuildDifference it = (BuildDifference)a;
                                Comparable comparable = Long.valueOf(it.getTs());
                                it = (BuildDifference)b;
                                Comparable comparable2 = comparable;
                                Long l = it.getTs();
                                return ComparisonsKt.compareValues(comparable2, (Comparable)l);
                            }
                        };
                        List<BuildDifference> diffsToWrite = CollectionsKt.takeLast(CollectionsKt.sortedWith(iterable, comparator), Companion.getMAX_DIFFS_ENTRIES$incremental_compilation_impl());
                        output.writeInt(diffsToWrite.size());
                        for (BuildDifference diff : diffsToWrite) {
                            Companion.writeBuildDifference(output, diff);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, throwable);
                    }
                }
                catch (IOException e) {
                    ICReporter iCReporter = reporter;
                    if (iCReporter == null) break block8;
                    iCReporter.report(new Function0<String>(file2, e){
                        final /* synthetic */ File $file;
                        final /* synthetic */ IOException $e;

                        @NotNull
                        public final String invoke() {
                            return "Could not write diff to file " + this.$file + ": " + this.$e;
                        }
                        {
                            this.$file = file2;
                            this.$e = iOException;
                            super(0);
                        }
                    });
                }
            }
        }

        private final BuildDifference readBuildDifference(@NotNull ObjectInputStream $receiver) {
            long ts = $receiver.readLong();
            boolean isIncremental = $receiver.readBoolean();
            DirtyData dirtyData = this.readDirtyData($receiver);
            return new BuildDifference(ts, isIncremental, dirtyData);
        }

        private final void writeBuildDifference(@NotNull ObjectOutputStream $receiver, BuildDifference diff) {
            $receiver.writeLong(diff.getTs());
            $receiver.writeBoolean(diff.isIncremental());
            this.writeDirtyData($receiver, diff.getDirtyData());
        }

        private final DirtyData readDirtyData(@NotNull ObjectInputStream $receiver) {
            int lookupSymbolSize = $receiver.readInt();
            ArrayList<LookupSymbol> lookupSymbols = new ArrayList<LookupSymbol>(lookupSymbolSize);
            int n = 0;
            int n2 = lookupSymbolSize;
            while (n < n2) {
                int it = n++;
                String name = $receiver.readUTF();
                String scope = $receiver.readUTF();
                String string = name;
                Intrinsics.checkExpressionValueIsNotNull(string, "name");
                String string2 = scope;
                Intrinsics.checkExpressionValueIsNotNull(string2, "scope");
                lookupSymbols.add(new LookupSymbol(string, string2));
            }
            int dirtyClassesSize = $receiver.readInt();
            ArrayList<FqName> dirtyClassesFqNames = new ArrayList<FqName>(dirtyClassesSize);
            int n3 = 0;
            int n4 = dirtyClassesSize;
            while (n3 < n4) {
                int it = n3++;
                String fqNameString = $receiver.readUTF();
                dirtyClassesFqNames.add(new FqName(fqNameString));
            }
            return new DirtyData((Collection<LookupSymbol>)lookupSymbols, (Collection<FqName>)dirtyClassesFqNames);
        }

        private final void writeDirtyData(@NotNull ObjectOutputStream $receiver, DirtyData dirtyData) {
            Collection<LookupSymbol> lookupSymbols = dirtyData.getDirtyLookupSymbols();
            $receiver.writeInt(lookupSymbols.size());
            for (LookupSymbol lookupSymbol : lookupSymbols) {
                String name = lookupSymbol.component1();
                String scope = lookupSymbol.component2();
                $receiver.writeUTF(name);
                $receiver.writeUTF(scope);
            }
            Collection<FqName> dirtyClassesFqNames = dirtyData.getDirtyClassesFqNames();
            $receiver.writeInt(dirtyClassesFqNames.size());
            for (FqName fqName2 : dirtyClassesFqNames) {
                $receiver.writeUTF(fqName2.asString());
            }
        }

        public final int getMAX_DIFFS_ENTRIES$incremental_compilation_impl() {
            return MAX_DIFFS_ENTRIES;
        }

        public final int getCURRENT_VERSION() {
            return CURRENT_VERSION;
        }

        public final void setCURRENT_VERSION(int n) {
            CURRENT_VERSION = n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

