/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackagePartProvider;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.KotlinMetadataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPackageFragment;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializedPackageFragment;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "packagePartProvider", "Lorg/jetbrains/kotlin/descriptors/PackagePartProvider;", "finder", "Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/descriptors/PackagePartProvider;Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;)V", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "components", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "memberScope", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "computeMemberScope", "getMemberScope", "hasTopLevelClass", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "initialize", "", "readProto", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "stream", "Ljava/io/InputStream;", "Companion", "deserialization"})
public final class MetadataPackageFragment
extends DeserializedPackageFragment {
    @NotNull
    private final ClassDataFinder classDataFinder;
    private DeserializationComponents components;
    private final NotNullLazyValue<MemberScope> memberScope;
    private final PackagePartProvider packagePartProvider;
    private final KotlinMetadataFinder finder;
    @NotNull
    private static final String DOT_METADATA_FILE_EXTENSION = ".kotlin_metadata";
    @NotNull
    private static final String METADATA_FILE_EXTENSION = "kotlin_metadata";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ClassDataFinder getClassDataFinder() {
        return this.classDataFinder;
    }

    @Override
    public void initialize(@NotNull DeserializationComponents components) {
        Intrinsics.checkParameterIsNotNull(components, "components");
        this.components = components;
    }

    /*
     * WARNING - void declaration
     */
    private final MemberScope computeMemberScope() {
        String string = this.getFqName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "fqName.asString()");
        List<String> packageParts = this.packagePartProvider.findMetadataPackageParts(string);
        ArrayList<DeserializedPackageMemberScope> scopes = new ArrayList<DeserializedPackageMemberScope>();
        for (String partName : packageParts) {
            void proto;
            InputStream stream2;
            if (this.finder.findMetadata(new ClassId(this.getFqName(), Name.identifier(partName))) == null) {
                continue;
            }
            Pair<ProtoBuf.PackageFragment, NameResolverImpl> pair = this.readProto(stream2);
            ProtoBuf.PackageFragment packageFragment = pair.component1();
            NameResolverImpl nameResolver = pair.component2();
            PackageFragmentDescriptor packageFragmentDescriptor = this;
            ProtoBuf.Package package_ = proto.getPackage();
            Intrinsics.checkExpressionValueIsNotNull(package_, "proto.`package`");
            NameResolver nameResolver2 = nameResolver;
            DeserializationComponents deserializationComponents = this.components;
            if (deserializationComponents == null) {
                Intrinsics.throwUninitializedPropertyAccessException("components");
            }
            scopes.add(new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, nameResolver2, null, deserializationComponents, computeMemberScope.1.INSTANCE));
        }
        PackageFragmentDescriptor packageFragmentDescriptor = this;
        ProtoBuf.Package package_ = ProtoBuf.Package.getDefaultInstance();
        Intrinsics.checkExpressionValueIsNotNull(package_, "ProtoBuf.Package.getDefaultInstance()");
        ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
        Intrinsics.checkExpressionValueIsNotNull(stringTable, "ProtoBuf.StringTable.getDefaultInstance()");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
        Intrinsics.checkExpressionValueIsNotNull(qualifiedNameTable, "ProtoBuf.QualifiedNameTable.getDefaultInstance()");
        NameResolver nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException("components");
        }
        scopes.add(new DeserializedPackageMemberScope(this, packageFragmentDescriptor, package_, nameResolver, null, deserializationComponents, computeMemberScope.3.INSTANCE){
            final /* synthetic */ MetadataPackageFragment this$0;

            protected boolean hasClass(@NotNull Name name) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                return this.this$0.hasTopLevelClass(name);
            }

            public boolean definitelyDoesNotContainName(@NotNull Name name) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                return false;
            }

            @Nullable
            public Set<Name> getClassifierNames() {
                return null;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
        return ChainedMemberScope.Companion.create("Metadata scope", (List<? extends MemberScope>)scopes);
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        return (MemberScope)this.memberScope.invoke();
    }

    @Override
    public boolean hasTopLevelClass(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return true;
    }

    private final Pair<ProtoBuf.PackageFragment, NameResolverImpl> readProto(InputStream stream2) {
        ProtoBuf.PackageFragment message;
        BuiltInsBinaryVersion version = BuiltInsBinaryVersion.Companion.readFrom(stream2);
        if (!version.isCompatible()) {
            throw (Throwable)new UnsupportedOperationException("Kotlin metadata definition format version is not supported: " + "expected " + BuiltInsBinaryVersion.INSTANCE + ", actual " + version + ". " + "Please update Kotlin");
        }
        ProtoBuf.PackageFragment packageFragment = message = ProtoBuf.PackageFragment.parseFrom(stream2, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
        Intrinsics.checkExpressionValueIsNotNull(packageFragment, "message");
        ProtoBuf.StringTable stringTable = packageFragment.getStrings();
        Intrinsics.checkExpressionValueIsNotNull(stringTable, "message.strings");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = message.getQualifiedNames();
        Intrinsics.checkExpressionValueIsNotNull(qualifiedNameTable, "message.qualifiedNames");
        NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
        return new Pair<ProtoBuf.PackageFragment, NameResolverImpl>(message, nameResolver);
    }

    public MetadataPackageFragment(@NotNull FqName fqName2, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module2, @NotNull PackagePartProvider packagePartProvider, @NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(packagePartProvider, "packagePartProvider");
        Intrinsics.checkParameterIsNotNull(finder, "finder");
        super(fqName2, storageManager, module2);
        this.packagePartProvider = packagePartProvider;
        this.finder = finder;
        this.classDataFinder = new ClassDataFinder(this){
            final /* synthetic */ MetadataPackageFragment this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ClassData findClassData(@NotNull ClassId classId) {
                ClassData classData;
                Object v4;
                NameResolverImpl nameResolver;
                Serializable serializable;
                block4: {
                    void message;
                    Intrinsics.checkParameterIsNotNull(classId, "classId");
                    ClassId topLevelClassId2 = SequencesKt.last(SequencesKt.generateSequence(classId, (Function1)classDataFinder.topLevelClassId.1.INSTANCE));
                    InputStream inputStream = MetadataPackageFragment.access$getFinder$p(this.this$0).findMetadata(topLevelClassId2);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStream stream2 = inputStream;
                    serializable = MetadataPackageFragment.access$readProto(this.this$0, stream2);
                    ProtoBuf.PackageFragment packageFragment = (ProtoBuf.PackageFragment)serializable.component1();
                    nameResolver = (NameResolverImpl)serializable.component2();
                    List<ProtoBuf.Class> list2 = message.getClass_List();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "message.class_List");
                    Iterable $receiver$iv = list2;
                    for (T element$iv : $receiver$iv) {
                        ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv;
                        NameResolver nameResolver2 = nameResolver;
                        ProtoBuf.Class clazz = classProto;
                        Intrinsics.checkExpressionValueIsNotNull(clazz, "classProto");
                        if (!Intrinsics.areEqual(NameResolverUtilKt.getClassId(nameResolver2, clazz.getFqName()), classId)) continue;
                        v4 = element$iv;
                        break block4;
                    }
                    v4 = null;
                }
                ProtoBuf.Class clazz = v4;
                if (clazz != null) {
                    Serializable classProto = serializable = clazz;
                    NameResolver nameResolver3 = nameResolver;
                    SourceElement sourceElement = SourceElement.NO_SOURCE;
                    Intrinsics.checkExpressionValueIsNotNull(sourceElement, "SourceElement.NO_SOURCE");
                    classData = new ClassData(nameResolver3, (ProtoBuf.Class)classProto, sourceElement);
                } else {
                    classData = null;
                }
                return classData;
            }
            {
                this.this$0 = metadataPackageFragment;
            }
        };
        this.memberScope = storageManager.createLazyValue((Function0)new Function0<MemberScope>(this){
            final /* synthetic */ MetadataPackageFragment this$0;

            @NotNull
            public final MemberScope invoke() {
                return MetadataPackageFragment.access$computeMemberScope(this.this$0);
            }
            {
                this.this$0 = metadataPackageFragment;
                super(0);
            }
        });
    }

    static {
        DOT_METADATA_FILE_EXTENSION = DOT_METADATA_FILE_EXTENSION;
        METADATA_FILE_EXTENSION = METADATA_FILE_EXTENSION;
    }

    @NotNull
    public static final /* synthetic */ KotlinMetadataFinder access$getFinder$p(MetadataPackageFragment $this) {
        return $this.finder;
    }

    @NotNull
    public static final /* synthetic */ Pair access$readProto(MetadataPackageFragment $this, @NotNull InputStream stream2) {
        return $this.readProto(stream2);
    }

    @NotNull
    public static final /* synthetic */ MemberScope access$computeMemberScope(MetadataPackageFragment $this) {
        return $this.computeMemberScope();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPackageFragment$Companion;", "", "()V", "DOT_METADATA_FILE_EXTENSION", "", "getDOT_METADATA_FILE_EXTENSION", "()Ljava/lang/String;", "METADATA_FILE_EXTENSION", "getMETADATA_FILE_EXTENSION", "deserialization"})
    public static final class Companion {
        @NotNull
        public final String getDOT_METADATA_FILE_EXTENSION() {
            return DOT_METADATA_FILE_EXTENSION;
        }

        @NotNull
        public final String getMETADATA_FILE_EXTENSION() {
            return METADATA_FILE_EXTENSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

