/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.toolchain.RequirementMatcher;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.logging.Logger;

public abstract class DefaultToolchain
implements Toolchain,
ToolchainPrivate {
    private String type;
    private Map<String, RequirementMatcher> provides = new HashMap<String, RequirementMatcher>();
    public static final String KEY_TYPE = "type";
    private ToolchainModel model;
    private Logger logger;

    protected DefaultToolchain(ToolchainModel model, Logger logger) {
        this.model = model;
        this.logger = logger;
    }

    protected DefaultToolchain(ToolchainModel model, String type, Logger logger) {
        this(model, logger);
        this.type = type;
    }

    @Override
    public final String getType() {
        return this.type != null ? this.type : this.model.getType();
    }

    @Override
    public final ToolchainModel getModel() {
        return this.model;
    }

    public final void addProvideToken(String type, RequirementMatcher matcher) {
        this.provides.put(type, matcher);
    }

    @Override
    public boolean matchesRequirements(Map<String, String> requirements) {
        for (Map.Entry<String, String> requirement : requirements.entrySet()) {
            String key = requirement.getKey();
            RequirementMatcher matcher = this.provides.get(key);
            if (matcher == null) {
                this.getLog().debug("Toolchain " + this + " is missing required property: " + key);
                return false;
            }
            if (matcher.matches(requirement.getValue())) continue;
            this.getLog().debug("Toolchain " + this + " doesn't match required property: " + key);
            return false;
        }
        return true;
    }

    protected Logger getLog() {
        return this.logger;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultToolchain)) {
            return false;
        }
        DefaultToolchain other = (DefaultToolchain)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        Properties thisProvides = this.getModel().getProvides();
        Properties otherProvides = other.getModel().getProvides();
        return !(thisProvides == null ? otherProvides != null : !thisProvides.equals(otherProvides));
    }

    public int hashCode() {
        int hashCode;
        int n = hashCode = this.type == null ? 0 : this.type.hashCode();
        if (this.getModel().getProvides() != null) {
            hashCode = 31 * hashCode + this.getModel().getProvides().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type:").append(this.getType());
        builder.append('{');
        Iterator<Map.Entry<String, RequirementMatcher>> providesIter = this.provides.entrySet().iterator();
        while (providesIter.hasNext()) {
            Map.Entry<String, RequirementMatcher> provideEntry = providesIter.next();
            builder.append(provideEntry.getKey()).append(" = ").append(provideEntry.getValue());
            if (!providesIter.hasNext()) continue;
            builder.append(';');
        }
        builder.append('}');
        return builder.toString();
    }
}

