/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.metrics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.protege.editor.owl.ui.metrics.ExpressivityIcons;
import org.semanticweb.owlapi.util.DLExpressivityChecker;

public class DLNamePanel
extends JPanel {
    private List<Icon> icons = new ArrayList<Icon>();
    private int maxHeight = 0;
    private int maxWidth = 0;
    private static final int TRACKING_ADJUSTMENT = -7;

    public void setConstructs(List<DLExpressivityChecker.Construct> constructs) {
        this.icons.clear();
        for (DLExpressivityChecker.Construct constuct : constructs) {
            Icon curIcon = ExpressivityIcons.getIcon(constuct);
            if (curIcon == null) continue;
            this.icons.add(curIcon);
            if (curIcon.getIconHeight() > this.maxHeight) {
                this.maxHeight = curIcon.getIconHeight();
            }
            this.maxWidth += curIcon.getIconWidth() + -7;
        }
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.maxWidth + insets.left + insets.right, this.maxHeight + insets.top + insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        g.translate(insets.left, insets.top);
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        for (Icon icon : this.icons) {
            int y = this.maxHeight - icon.getIconHeight();
            icon.paintIcon(this, g2, x, y);
            x += icon.getIconWidth() + -7;
        }
        g.translate(-insets.left, -insets.top);
    }
}

