/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.renderer.prefix.ActiveOntologyComparator;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.formats.PrefixDocumentFormatImpl;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixUtilities {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefixUtilities.class);
    public static final Set<String> STANDARD_PREFIXES = Collections.unmodifiableSet(new DefaultPrefixManager().getPrefixNames());

    public static PrefixManager getPrefixOWLOntologyFormat(OWLModelManager modelManager) {
        OWLOntologyManager owlManager = modelManager.getOWLOntologyManager();
        DefaultPrefixManager prefixes = new DefaultPrefixManager();
        ArrayList<OWLOntology> ontologies = new ArrayList<OWLOntology>(modelManager.getOntologies());
        Collections.sort(ontologies, new ActiveOntologyComparator());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sorted ontologies = " + ontologies);
        }
        HashSet<String> prefixValues = new HashSet<String>();
        for (OWLOntology ontology : ontologies) {
            OWLDocumentFormat format = owlManager.getOntologyFormat(ontology);
            if (!(format instanceof PrefixDocumentFormat)) continue;
            PrefixDocumentFormat newPrefixes = (PrefixDocumentFormat)format;
            for (Map.Entry entry : newPrefixes.getPrefixName2PrefixMap().entrySet()) {
                String prefixName = (String)entry.getKey();
                String prefix = (String)entry.getValue();
                if (prefixes.containsPrefixMapping(prefixName) || prefixValues.contains(prefix)) continue;
                prefixes.setPrefix(prefixName, prefix);
                prefixValues.add(prefix);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Merged prefix to prefix value map = " + prefixes.getPrefixName2PrefixMap());
        }
        return prefixes;
    }

    public static PrefixDocumentFormat getPrefixOWLOntologyFormat(OWLOntology ontology) {
        OWLOntologyManager manager;
        OWLDocumentFormat format;
        PrefixDocumentFormatImpl prefixManager = null;
        if (ontology != null && (format = (manager = ontology.getOWLOntologyManager()).getOntologyFormat(ontology)) != null && format.isPrefixOWLOntologyFormat()) {
            prefixManager = format.asPrefixOWLOntologyFormat();
        }
        if (prefixManager == null) {
            prefixManager = new PrefixDocumentFormatImpl();
        }
        return prefixManager;
    }

    public static boolean isStandardPrefix(String prefix) {
        return STANDARD_PREFIXES.contains(prefix + ":");
    }
}

