/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.coode.owlapi.obo12.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;

class DefTagValueHandler
extends AbstractTagValueHandler {
    private static final Pattern PATTERN = Pattern.compile("\"([^\"]*)\"\\s*(\\[([^\\]]*)\\])?\\s*");
    private static final int QUOTED_STRING_CONTENT_GROUP = 1;
    private static final int XREF_GROUP = 3;

    public DefTagValueHandler(@Nonnull OBOConsumer consumer) {
        super(OBOVocabulary.DEF.getName(), consumer);
    }

    @Override
    public void handle(String currentId, String value, String qualifierBlock, String comment) {
        String annotationValue;
        Matcher matcher = PATTERN.matcher(value);
        OWLDataFactory df = this.getDataFactory();
        Set<Object> xrefAnnotations = Collections.emptySet();
        if (matcher.matches()) {
            annotationValue = matcher.group(1);
            xrefAnnotations = this.getXRefAnnotations(matcher);
        } else {
            annotationValue = this.getUnquotedString(value);
        }
        IRI propertyIRI = this.getTagIRI(this.getTagName());
        OWLAnnotationProperty property = df.getOWLAnnotationProperty(propertyIRI);
        OWLEntity currentEntity = this.getConsumer().getCurrentEntity();
        OWLLiteral literal = df.getOWLLiteral(annotationValue);
        OWLAnnotationAssertionAxiom ax = df.getOWLAnnotationAssertionAxiom(property, currentEntity.getIRI(), literal, xrefAnnotations);
        this.applyChange(new AddAxiom(this.getOntology(), ax));
    }

    @Nonnull
    private Set<OWLAnnotation> getXRefAnnotations(Matcher matcher) {
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        String xrefs = matcher.group(3);
        if (xrefs != null) {
            StringTokenizer tokenizer = new StringTokenizer(xrefs, ",");
            while (tokenizer.hasMoreTokens()) {
                String xrefValue = tokenizer.nextToken();
                assert (xrefValue != null);
                OWLAnnotation xrefAnnotation = this.getConsumer().parseXRef(xrefValue);
                annotations.add(xrefAnnotation);
            }
        }
        return annotations;
    }
}

