/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.util.Locale;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.extension.httppanel.view.largerequest.LargeRequestUtil;
import org.zaproxy.zap.extension.httppanel.view.largeresponse.LargeResponseUtil;

public class OptionsParamView
extends AbstractParam {
    private static final String DEFAULT_TIME_STAMP_FORMAT = Constant.messages.getString("timestamp.format.default");
    public static final String BASE_VIEW_KEY = "view";
    private static final String SHOW_TEXT_ICONS = "view.showTabNames";
    private static final String PROCESS_IMAGES = "view.processImages";
    public static final String LOCALE = "view.locale";
    public static final String LOCALES = "view.locales";
    public static final String DISPLAY_OPTION = "view.displayOption";
    private static final String RESPONSE_PANEL_POS_KEY = "view.messagePanelsPosition.lastSelectedPosition";
    public static final String BRK_PANEL_VIEW_OPTION = "view.brkPanelView";
    public static final String SHOW_MAIN_TOOLBAR_OPTION = "view.showMainToolbar";
    public static final String DEFAULT_LOCALE = "en_GB";
    public static final String ADVANCEDUI_OPTION = "view.advancedview";
    public static final String WMUIHANDLING_OPTION = "view.uiWmHandling";
    public static final String ASKONEXIT_OPTION = "view.askOnExit";
    public static final String WARN_ON_TAB_DOUBLE_CLICK_OPTION = "view.warnOnTabDoubleClick";
    public static final String MODE_OPTION = "view.mode";
    public static final String TAB_PIN_OPTION = "view.tab.pin";
    public static final String OUTPUT_TAB_TIMESTAMPING_OPTION = "view.outputTabsTimeStampsOption";
    public static final String OUTPUT_TAB_TIMESTAMP_FORMAT = "view.outputTabsTimeStampsFormat";
    private static final String SHOW_LOCAL_CONNECT_REQUESTS = "view.showLocalConnectRequests";
    private static final String USE_SYSTEMS_LOCALE_FOR_FORMAT_KEY = "view.usesystemslocaleformat";
    public static final String SPLASHSCREEN_OPTION = "view.splashScreen";
    public static final String LARGE_REQUEST_SIZE = "view.largeRequest";
    public static final String LARGE_RESPONSE_SIZE = "view.largeResponse";
    public static final String FONT_NAME = "view.fontName";
    public static final String FONT_SIZE = "view.fontSize";
    public static final String SCALE_IMAGES = "view.scaleImages";
    public static final String SHOW_DEV_WARNING = "view.showDevWarning";
    private static final String CONFIRM_REMOVE_PROXY_EXCLUDE_REGEX_KEY = "view.confirmRemoveProxyExcludeRegex";
    private static final String CONFIRM_REMOVE_SCANNER_EXCLUDE_REGEX_KEY = "view.confirmRemoveScannerExcludeRegex";
    private static final String CONFIRM_REMOVE_SPIDER_EXCLUDE_REGEX_KEY = "view.confirmRemoveSpiderExcludeRegex";
    private int advancedViewEnabled = 0;
    private int processImages = 0;
    private int showMainToolbar = 1;
    private String configLocale = "";
    private String locale = "";
    private int displayOption = 0;
    private String responsePanelPosition;
    private int brkPanelViewOption = 0;
    private int askOnExitEnabled = 1;
    private int wmUiHandlingEnabled = 0;
    private boolean warnOnTabDoubleClick = false;
    private boolean showTabNames = true;
    private String mode = Control.Mode.standard.name();
    private boolean outputTabTimeStampingEnabled = false;
    private String outputTabTimeStampFormat = DEFAULT_TIME_STAMP_FORMAT;
    private boolean showLocalConnectRequests;
    private boolean showSplashScreen = true;
    private int largeRequestSize = 100000;
    private int largeResponseSize = 100000;
    private int fontSize = -1;
    private String fontName = "";
    private boolean scaleImages = true;
    private boolean showDevWarning = true;
    private boolean confirmRemoveProxyExcludeRegex;
    private boolean confirmRemoveScannerExcludeRegex;
    private boolean confirmRemoveSpiderExcludeRegex;
    private boolean useSystemsLocaleForFormat;

    @Override
    protected void parse() {
        this.showTabNames = this.getBoolean(SHOW_TEXT_ICONS, true);
        this.processImages = this.getInt(PROCESS_IMAGES, 0);
        this.configLocale = this.getString(LOCALE, null);
        this.locale = this.getString(LOCALE, DEFAULT_LOCALE);
        this.useSystemsLocaleForFormat = this.getBoolean(USE_SYSTEMS_LOCALE_FOR_FORMAT_KEY, true);
        this.displayOption = this.getInt(DISPLAY_OPTION, 0);
        this.responsePanelPosition = this.getString(RESPONSE_PANEL_POS_KEY, WorkbenchPanel.ResponsePanelPosition.TABS_SIDE_BY_SIDE.name());
        this.brkPanelViewOption = this.getInt(BRK_PANEL_VIEW_OPTION, 0);
        this.showMainToolbar = this.getInt(SHOW_MAIN_TOOLBAR_OPTION, 1);
        this.advancedViewEnabled = this.getInt(ADVANCEDUI_OPTION, 0);
        this.wmUiHandlingEnabled = this.getInt(WMUIHANDLING_OPTION, 0);
        this.askOnExitEnabled = this.getInt(ASKONEXIT_OPTION, 1);
        this.warnOnTabDoubleClick = this.getBoolean(WARN_ON_TAB_DOUBLE_CLICK_OPTION, true);
        this.mode = this.getString(MODE_OPTION, Control.Mode.standard.name());
        this.outputTabTimeStampingEnabled = this.getBoolean(OUTPUT_TAB_TIMESTAMPING_OPTION, false);
        this.outputTabTimeStampFormat = this.getString(OUTPUT_TAB_TIMESTAMP_FORMAT, DEFAULT_TIME_STAMP_FORMAT);
        this.showLocalConnectRequests = this.getBoolean(SHOW_LOCAL_CONNECT_REQUESTS, false);
        this.showSplashScreen = this.getBoolean(SPLASHSCREEN_OPTION, true);
        this.largeRequestSize = this.getInt(LARGE_REQUEST_SIZE, 100000);
        this.largeResponseSize = this.getInt(LARGE_RESPONSE_SIZE, 100000);
        this.fontSize = this.getInt(FONT_SIZE, -1);
        this.fontName = this.getString(FONT_NAME, "");
        this.scaleImages = this.getBoolean(SCALE_IMAGES, true);
        this.showDevWarning = this.getBoolean(SHOW_DEV_WARNING, true);
        LargeRequestUtil.setMinContentLength(this.largeRequestSize);
        LargeResponseUtil.setMinContentLength(this.largeResponseSize);
        this.confirmRemoveProxyExcludeRegex = this.getBoolean(CONFIRM_REMOVE_PROXY_EXCLUDE_REGEX_KEY, false);
        this.confirmRemoveScannerExcludeRegex = this.getBoolean(CONFIRM_REMOVE_SCANNER_EXCLUDE_REGEX_KEY, false);
        this.confirmRemoveSpiderExcludeRegex = this.getBoolean(CONFIRM_REMOVE_SPIDER_EXCLUDE_REGEX_KEY, false);
    }

    public int getProcessImages() {
        return this.processImages;
    }

    public void setProcessImages(int processImages) {
        this.processImages = processImages;
        this.getConfig().setProperty(PROCESS_IMAGES, (Object)Integer.toString(processImages));
    }

    public boolean isProcessImages() {
        return this.processImages != 0;
    }

    @Deprecated
    public int getShowMainToolbar() {
        return this.showMainToolbar;
    }

    public boolean isShowMainToolbar() {
        return this.showMainToolbar != 0;
    }

    @Deprecated
    public void setShowMainToolbar(int showMainToolbar) {
        this.setShowMainToolbar(showMainToolbar != 0);
    }

    public void setShowMainToolbar(boolean show) {
        this.showMainToolbar = show ? 1 : 0;
        this.getConfig().setProperty(SHOW_MAIN_TOOLBAR_OPTION, (Object)this.showMainToolbar);
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        if (locale != null) {
            this.locale = locale;
            this.getConfig().setProperty(LOCALE, (Object)locale);
        }
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(locale.getLanguage());
            if (locale.getCountry().length() > 0) {
                sb.append("_").append(locale.getCountry());
            }
            if (locale.getVariant().length() > 0) {
                sb.append("_").append(locale.getVariant());
            }
            this.setLocale(sb.toString());
        }
    }

    public String getConfigLocale() {
        return this.configLocale;
    }

    public boolean getShowTabNames() {
        return this.showTabNames;
    }

    public void setShowTabNames(boolean showTabNames) {
        this.showTabNames = showTabNames;
        this.getConfig().setProperty(SHOW_TEXT_ICONS, (Object)showTabNames);
    }

    public int getBrkPanelViewOption() {
        return this.brkPanelViewOption;
    }

    public void setBrkPanelViewOption(int brkPanelViewIdx) {
        this.brkPanelViewOption = brkPanelViewIdx;
        this.getConfig().setProperty(BRK_PANEL_VIEW_OPTION, (Object)Integer.toString(this.brkPanelViewOption));
    }

    public int getDisplayOption() {
        return this.displayOption;
    }

    public void setDisplayOption(int displayOption) {
        this.displayOption = displayOption;
        this.getConfig().setProperty(DISPLAY_OPTION, (Object)Integer.toString(displayOption));
    }

    public String getResponsePanelPosition() {
        return this.responsePanelPosition;
    }

    public void setResponsePanelPosition(String position) {
        this.responsePanelPosition = position;
        this.getConfig().setProperty(RESPONSE_PANEL_POS_KEY, (Object)position);
    }

    public int getAdvancedViewOption() {
        return this.advancedViewEnabled;
    }

    public void setAdvancedViewOption(int isEnabled) {
        this.advancedViewEnabled = isEnabled;
        this.getConfig().setProperty(ADVANCEDUI_OPTION, (Object)Integer.toString(isEnabled));
    }

    public void setAskOnExitOption(int isEnabled) {
        this.askOnExitEnabled = isEnabled;
        this.getConfig().setProperty(ASKONEXIT_OPTION, (Object)Integer.toString(isEnabled));
    }

    public int getAskOnExitOption() {
        return this.askOnExitEnabled;
    }

    public void setWmUiHandlingOption(int isEnabled) {
        this.wmUiHandlingEnabled = isEnabled;
        this.getConfig().setProperty(WMUIHANDLING_OPTION, (Object)Integer.toString(isEnabled));
    }

    public int getWmUiHandlingOption() {
        return this.wmUiHandlingEnabled;
    }

    public boolean getWarnOnTabDoubleClick() {
        return this.warnOnTabDoubleClick;
    }

    public void setWarnOnTabDoubleClick(boolean warnOnTabDoubleClick) {
        this.warnOnTabDoubleClick = warnOnTabDoubleClick;
        this.getConfig().setProperty(WARN_ON_TAB_DOUBLE_CLICK_OPTION, (Object)warnOnTabDoubleClick);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
        this.getConfig().setProperty(MODE_OPTION, (Object)mode);
    }

    public void setOutputTabTimeStampingEnabled(boolean enabled) {
        this.outputTabTimeStampingEnabled = enabled;
        this.getConfig().setProperty(OUTPUT_TAB_TIMESTAMPING_OPTION, (Object)enabled);
    }

    public boolean isOutputTabTimeStampingEnabled() {
        return this.outputTabTimeStampingEnabled;
    }

    public void setOutputTabTimeStampsFormat(String format) {
        this.outputTabTimeStampFormat = format;
        this.getConfig().setProperty(OUTPUT_TAB_TIMESTAMP_FORMAT, (Object)format);
    }

    public String getOutputTabTimeStampsFormat() {
        return this.outputTabTimeStampFormat;
    }

    public void setShowLocalConnectRequests(boolean showConnectRequests) {
        if (this.showLocalConnectRequests != showConnectRequests) {
            this.showLocalConnectRequests = showConnectRequests;
            this.getConfig().setProperty(SHOW_LOCAL_CONNECT_REQUESTS, (Object)showConnectRequests);
        }
    }

    public boolean isShowLocalConnectRequests() {
        return this.showLocalConnectRequests;
    }

    public boolean isShowSplashScreen() {
        return this.showSplashScreen;
    }

    public void setShowSplashScreen(boolean showSplashScreen) {
        this.showSplashScreen = showSplashScreen;
        this.getConfig().setProperty(SPLASHSCREEN_OPTION, (Object)showSplashScreen);
    }

    public int getLargeRequestSize() {
        return this.largeRequestSize;
    }

    public void setLargeRequestSize(int largeRequestSize) {
        this.largeRequestSize = largeRequestSize;
        LargeRequestUtil.setMinContentLength(largeRequestSize);
        this.getConfig().setProperty(LARGE_REQUEST_SIZE, (Object)largeRequestSize);
    }

    public int getLargeResponseSize() {
        return this.largeResponseSize;
    }

    public void setLargeResponseSize(int largeResponseSize) {
        this.largeResponseSize = largeResponseSize;
        LargeResponseUtil.setMinContentLength(largeResponseSize);
        this.getConfig().setProperty(LARGE_RESPONSE_SIZE, (Object)largeResponseSize);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.getConfig().setProperty(FONT_SIZE, (Object)fontSize);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        this.getConfig().setProperty(FONT_NAME, (Object)fontName);
    }

    public boolean isScaleImages() {
        return this.scaleImages;
    }

    public void setScaleImages(boolean scaleImages) {
        this.scaleImages = scaleImages;
        this.getConfig().setProperty(SCALE_IMAGES, (Object)scaleImages);
    }

    public boolean isShowDevWarning() {
        return this.showDevWarning;
    }

    public void setShowDevWarning(boolean showDevWarning) {
        this.showDevWarning = showDevWarning;
        this.getConfig().setProperty(SHOW_DEV_WARNING, (Object)showDevWarning);
    }

    public boolean isConfirmRemoveProxyExcludeRegex() {
        return this.confirmRemoveProxyExcludeRegex;
    }

    public void setConfirmRemoveProxyExcludeRegex(boolean confirmRemove) {
        this.confirmRemoveProxyExcludeRegex = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_PROXY_EXCLUDE_REGEX_KEY, (Object)confirmRemove);
    }

    public boolean isConfirmRemoveScannerExcludeRegex() {
        return this.confirmRemoveScannerExcludeRegex;
    }

    public void setConfirmRemoveScannerExcludeRegex(boolean confirmRemove) {
        this.confirmRemoveScannerExcludeRegex = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_SCANNER_EXCLUDE_REGEX_KEY, (Object)confirmRemove);
    }

    public boolean isConfirmRemoveSpiderExcludeRegex() {
        return this.confirmRemoveSpiderExcludeRegex;
    }

    public void setConfirmRemoveSpiderExcludeRegex(boolean confirmRemove) {
        this.confirmRemoveSpiderExcludeRegex = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_SPIDER_EXCLUDE_REGEX_KEY, (Object)confirmRemove);
    }

    public void setUseSystemsLocaleForFormat(boolean useSystemsLocale) {
        if (this.useSystemsLocaleForFormat != useSystemsLocale) {
            this.useSystemsLocaleForFormat = useSystemsLocale;
            this.getConfig().setProperty(USE_SYSTEMS_LOCALE_FOR_FORMAT_KEY, (Object)this.useSystemsLocaleForFormat);
        }
    }

    public boolean isUseSystemsLocaleForFormat() {
        return this.useSystemsLocaleForFormat;
    }
}

