/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.Stats;

public abstract class AuthenticationMethod {
    public static final String CONTEXT_CONFIG_AUTH = "context.authentication";
    public static final String CONTEXT_CONFIG_AUTH_TYPE = "context.authentication.type";
    public static final String CONTEXT_CONFIG_AUTH_LOGGEDIN = "context.authentication.loggedin";
    public static final String CONTEXT_CONFIG_AUTH_LOGGEDOUT = "context.authentication.loggedout";
    public static final String AUTH_STATE_LOGGED_IN_STATS = "stats.auth.state.loggedin";
    public static final String AUTH_STATE_LOGGED_OUT_STATS = "stats.auth.state.loggedout";
    public static final String AUTH_STATE_NO_INDICATOR_STATS = "stats.auth.state.noindicator";
    public static final String AUTH_STATE_UNKNOWN_STATS = "stats.auth.state.unknown";
    protected Pattern loggedInIndicatorPattern = null;
    protected Pattern loggedOutIndicatorPattern = null;

    public abstract boolean isConfigured();

    public AuthenticationMethod clone() {
        AuthenticationMethod method = this.duplicate();
        method.loggedInIndicatorPattern = this.loggedInIndicatorPattern;
        method.loggedOutIndicatorPattern = this.loggedOutIndicatorPattern;
        return method;
    }

    protected abstract AuthenticationMethod duplicate();

    public boolean validateCreationOfAuthenticationCredentials() {
        return true;
    }

    public abstract AuthenticationCredentials createAuthenticationCredentials();

    public abstract AuthenticationMethodType getType();

    public abstract WebSession authenticate(SessionManagementMethod var1, AuthenticationCredentials var2, User var3) throws UnsupportedAuthenticationCredentialsException;

    public abstract ApiResponse getApiResponseRepresentation();

    public void onMethodPersisted() {
    }

    public void onMethodDiscarded() {
    }

    public boolean isAuthenticated(HttpMessage msg) {
        if (msg == null || msg.getResponseBody() == null) {
            return false;
        }
        if (this.loggedInIndicatorPattern == null && this.loggedOutIndicatorPattern == null) {
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_NO_INDICATOR_STATS);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            if (View.isInitialised()) {
                View.getSingleton().getOutputPanel().append(Constant.messages.getString("authentication.output.indicatorsNotSet", msg.getRequestHeader().getURI()) + "\n");
            }
            return true;
        }
        String body = msg.getResponseBody().toString();
        String header = msg.getResponseHeader().toString();
        if (this.loggedInIndicatorPattern != null && (this.loggedInIndicatorPattern.matcher(body).find() || this.loggedInIndicatorPattern.matcher(header).find())) {
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_LOGGED_IN_STATS);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            return true;
        }
        if (this.loggedOutIndicatorPattern != null && !this.loggedOutIndicatorPattern.matcher(body).find() && !this.loggedOutIndicatorPattern.matcher(header).find()) {
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_UNKNOWN_STATS);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            return true;
        }
        try {
            Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_LOGGED_OUT_STATS);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        return false;
    }

    public Pattern getLoggedInIndicatorPattern() {
        return this.loggedInIndicatorPattern;
    }

    public void setLoggedInIndicatorPattern(String loggedInIndicatorPattern) {
        this.loggedInIndicatorPattern = loggedInIndicatorPattern == null || loggedInIndicatorPattern.trim().length() == 0 ? null : Pattern.compile(loggedInIndicatorPattern);
    }

    public Pattern getLoggedOutIndicatorPattern() {
        return this.loggedOutIndicatorPattern;
    }

    public void setLoggedOutIndicatorPattern(String loggedOutIndicatorPattern) {
        this.loggedOutIndicatorPattern = loggedOutIndicatorPattern == null || loggedOutIndicatorPattern.trim().length() == 0 ? null : Pattern.compile(loggedOutIndicatorPattern);
    }

    public boolean isSameType(AuthenticationMethod other) {
        if (other == null) {
            return false;
        }
        return other.getClass().equals(this.getClass());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loggedInIndicatorPattern == null ? 0 : this.loggedInIndicatorPattern.pattern().hashCode());
        result = 31 * result + (this.loggedOutIndicatorPattern == null ? 0 : this.loggedOutIndicatorPattern.pattern().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationMethod other = (AuthenticationMethod)obj;
        if (this.loggedInIndicatorPattern == null ? other.loggedInIndicatorPattern != null : !this.loggedInIndicatorPattern.pattern().equals(other.loggedInIndicatorPattern.pattern())) {
            return false;
        }
        return !(this.loggedOutIndicatorPattern == null ? other.loggedOutIndicatorPattern != null : !this.loggedOutIndicatorPattern.pattern().equals(other.loggedOutIndicatorPattern.pattern()));
    }

    public static class UnsupportedAuthenticationCredentialsException
    extends RuntimeException {
        private static final long serialVersionUID = 4802501809913124766L;

        public UnsupportedAuthenticationCredentialsException(String message) {
            super(message);
        }
    }
}

