/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarEntryTimings {
    public static String TABLE_NAME = "entry_timings";
    private Long blocked;
    private Long dns;
    private Long connect;
    private Long send;
    private Long wait;
    private Long receive;
    private Long ssl;
    private String comment;
    private HarCustomFields customFields = new HarCustomFields();

    public HarEntryTimings(long blocked, long dns, long connect, long send, long wait, long receive, long ssl, String comment) {
        this.blocked = blocked;
        this.dns = dns;
        this.connect = connect;
        this.send = send;
        this.wait = wait;
        this.receive = receive;
        this.ssl = ssl;
        this.comment = comment;
    }

    public HarEntryTimings(long send, long wait, long receive) {
        this.send = send;
        this.wait = wait;
        this.receive = receive;
    }

    public HarEntryTimings(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"timings\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("blocked".equals(name)) {
                this.setBlocked(jp.getValueAsLong());
                continue;
            }
            if ("dns".equals(name)) {
                this.setDns(jp.getValueAsLong());
                continue;
            }
            if ("connect".equals(name)) {
                this.setConnect(jp.getValueAsLong());
                continue;
            }
            if ("send".equals(name)) {
                this.setSend(jp.getValueAsLong());
                continue;
            }
            if ("wait".equals(name)) {
                this.setWait(jp.getValueAsLong());
                continue;
            }
            if ("receive".equals(name)) {
                this.setReceive(jp.getValueAsLong());
                continue;
            }
            if ("ssl".equals(name)) {
                this.setSsl(jp.getValueAsLong());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in timings element", jp.getCurrentLocation());
        }
        if (this.send == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing send field in timings element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing send field in timings element", jp.getCurrentLocation());
            }
        }
        if (this.wait == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing wait field in timings element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing wait field in timings element", jp.getCurrentLocation());
            }
        }
        if (this.receive == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing receive field in timings element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing receive field in timings element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarEntryTimings(HarDatabaseConfig config, long entryId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,blocked,dns,conect,send,wait,receive,ssl,comment FROM " + tableName + " WHERE entry_id=?");
            ps.setLong(1, entryId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarEntryTimings for entry id " + entryId + " found in database");
            }
            long timingId = rs.getLong(1);
            this.setBlocked(rs.getLong(2));
            if (rs.wasNull()) {
                this.blocked = null;
            }
            this.setDns(rs.getLong(3));
            if (rs.wasNull()) {
                this.dns = null;
            }
            this.setConnect(rs.getLong(4));
            if (rs.wasNull()) {
                this.connect = null;
            }
            this.setSend(rs.getLong(5));
            this.setWait(rs.getLong(6));
            this.setReceive(rs.getLong(7));
            this.setSsl(rs.getLong(8));
            if (rs.wasNull()) {
                this.ssl = null;
            }
            this.setComment(rs.getString(9));
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARENTRYTIMING, timingId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("timings");
        if (this.blocked != null) {
            g.writeNumberField("blocked", this.blocked);
        }
        if (this.dns != null) {
            g.writeNumberField("dns", this.dns);
        }
        if (this.connect != null) {
            g.writeNumberField("connect", this.connect);
        }
        g.writeNumberField("send", this.send);
        g.writeNumberField("wait", this.wait);
        g.writeNumberField("receive", this.receive);
        if (this.ssl != null) {
            g.writeNumberField("ssl", this.ssl);
        }
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long entryId, HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(tableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + tableName + " (id " + config.getDbAutoGeneratedId() + ",blocked " + config.getLongDbType() + ",dns " + config.getLongDbType() + ",conect " + config.getLongDbType() + ",send " + config.getLongDbType() + ",wait " + config.getLongDbType() + ",receive " + config.getLongDbType() + ",ssl " + config.getLongDbType() + ",comment " + config.getStringDbType() + ",entry_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(tableName);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        Statement ps = null;
        try {
            ps = c.prepareStatement("INSERT INTO " + tableName + " (blocked,dns,conect,send,wait,receive,ssl,comment,entry_id) VALUES (?,?,?,?,?,?,?,?,?)", 1);
            if (this.blocked == null) {
                ps.setNull(1, -5);
            } else {
                ps.setLong(1, this.blocked);
            }
            if (this.dns == null) {
                ps.setNull(2, -5);
            } else {
                ps.setLong(2, this.dns);
            }
            if (this.connect == null) {
                ps.setNull(3, -5);
            } else {
                ps.setLong(3, this.connect);
            }
            ps.setLong(4, this.send);
            ps.setLong(5, this.wait);
            ps.setLong(6, this.receive);
            if (this.ssl == null) {
                ps.setNull(7, -5);
            } else {
                ps.setLong(7, this.ssl);
            }
            if (this.comment == null) {
                ps.setNull(8, -1);
            } else {
                ps.setString(8, this.comment);
            }
            ps.setLong(9, entryId);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarEntry row");
            }
            long timingId = rs.getLong(1);
            this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARENTRYTIMING, timingId, logId);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        String tableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(tableName)) {
            return;
        }
        Connection c = config.getConnection();
        Statement ps = null;
        try {
            ps = c.prepareStatement("DELETE FROM " + tableName + " WHERE entry_id IN (SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?)");
            ps.setLong(1, logId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, tableName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public long getBlocked() {
        return this.blocked;
    }

    public void setBlocked(long blocked) {
        this.blocked = blocked;
    }

    public long getDns() {
        return this.dns;
    }

    public void setDns(long dns) {
        this.dns = dns;
    }

    public long getConnect() {
        return this.connect;
    }

    public void setConnect(long connect) {
        this.connect = connect;
    }

    public long getSend() {
        return this.send;
    }

    public void setSend(long send) {
        this.send = send;
    }

    public long getWait() {
        return this.wait;
    }

    public void setWait(long wait) {
        this.wait = wait;
    }

    public long getReceive() {
        return this.receive;
    }

    public void setReceive(long receive) {
        this.receive = receive;
    }

    public long getSsl() {
        return this.ssl;
    }

    public void setSsl(long ssl) {
        this.ssl = ssl;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "\"timings\": { \"blocked\": " + this.blocked + ", \"dns\": " + this.dns + ", \"connect\": " + this.connect + ", \"send\": " + this.send + ", \"wait\": " + this.wait + ", \"receive\": " + this.receive + ", \"ssl\": " + this.ssl + ", \"comment\": " + "\"" + this.comment + "\", " + this.customFields + "}\n";
    }
}

