/*
 * Decompiled with CFR 0.152.
 */
package com.sun.browser.plugin;

import com.sun.browser.plugin.DefaultPlugin;
import com.sun.browser.plugin.Plugin;
import com.sun.browser.plugin.PluginHandler;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginManager {
    private static final Logger log = Logger.getLogger("com.sun.browser.plugin.PluginManager");
    static ServiceLoader<PluginHandler> pHandlers = ServiceLoader.load(PluginHandler.class);
    static TreeMap<String, PluginHandler> hndMap = new TreeMap();
    static PluginHandler[] hndArray;
    static HashSet<String> disabledPluginHandlers;

    static void updatePluginHandlers() {
        log.fine("Update plugin handlers");
        hndMap.clear();
        for (PluginHandler object2 : pHandlers) {
            String[] stringArray;
            if (!object2.isSupportedPlatform() || PluginManager.isDisabledPlugin(object2)) continue;
            for (String string : stringArray = object2.supportedMIMETypes()) {
                hndMap.put(string, object2);
                log.fine(string);
            }
        }
        Collection<PluginHandler> collection = hndMap.values();
        hndArray = collection.toArray(new PluginHandler[collection.size()]);
    }

    public static Plugin createPlugin(URL uRL, String string, String[] stringArray, String[] stringArray2) {
        try {
            PluginHandler pluginHandler = hndMap.get(string);
            if (pluginHandler == null) {
                return new DefaultPlugin(uRL, string, stringArray, stringArray2);
            }
            Plugin plugin = pluginHandler.createPlugin(uRL, string, stringArray, stringArray2);
            if (plugin == null) {
                return new DefaultPlugin(uRL, string, stringArray, stringArray2);
            }
            return plugin;
        }
        catch (Throwable throwable) {
            log.log(Level.FINE, "Cannot create plugin", throwable);
            return new DefaultPlugin(uRL, string, stringArray, stringArray2);
        }
    }

    public static List<PluginHandler> getAvailablePlugins() {
        Vector<PluginHandler> vector = new Vector<PluginHandler>();
        for (PluginHandler pluginHandler : pHandlers) {
            if (!pluginHandler.isSupportedPlatform()) continue;
            vector.add(pluginHandler);
        }
        return vector;
    }

    public static PluginHandler getEnabledPlugin(int n) {
        if (n < 0 || n >= hndArray.length) {
            return null;
        }
        return hndArray[n];
    }

    public static int getEnabledPluginCount() {
        return hndArray.length;
    }

    public static void disablePlugin(PluginHandler pluginHandler) {
        disabledPluginHandlers.add(pluginHandler.getClass().getCanonicalName());
        PluginManager.updatePluginHandlers();
    }

    public static void enablePlugin(PluginHandler pluginHandler) {
        disabledPluginHandlers.remove(pluginHandler.getClass().getCanonicalName());
        PluginManager.updatePluginHandlers();
    }

    public static boolean isDisabledPlugin(PluginHandler pluginHandler) {
        return disabledPluginHandlers.contains(pluginHandler.getClass().getCanonicalName());
    }

    public static boolean supportsMIMEType(String string) {
        return hndMap.containsKey(string);
    }

    public static String getPluginNameForMIMEType(String string) {
        PluginHandler pluginHandler = hndMap.get(string);
        if (pluginHandler != null) {
            return pluginHandler.getName();
        }
        return "";
    }

    static {
        disabledPluginHandlers = new HashSet();
        if ("false".equalsIgnoreCase(System.getProperty("com.sun.browser.plugin"))) {
            for (PluginHandler pluginHandler : PluginManager.getAvailablePlugins()) {
                disabledPluginHandlers.add(pluginHandler.getClass().getCanonicalName());
            }
        }
        PluginManager.updatePluginHandlers();
    }
}

